/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.commands.CommandSourceStack;
import net.pcal.fastback.commands.Command;
import net.pcal.fastback.commands.Commands;
import net.pcal.fastback.commands.PermissionsFactory;
import net.pcal.fastback.config.OtherConfigKey;
import net.pcal.fastback.logging.UserLogger;
import net.pcal.fastback.logging.UserMessage;
import net.pcal.fastback.repo.SnapshotId;
import net.pcal.fastback.utils.Executor;

enum RemoteListCommand implements Command
{
    INSTANCE;

    private static final String COMMAND_NAME = "remote-list";

    @Override
    public void register(LiteralArgumentBuilder<CommandSourceStack> argb, PermissionsFactory<CommandSourceStack> pf) {
        argb.then(((LiteralArgumentBuilder)net.minecraft.commands.Commands.m_82127_((String)COMMAND_NAME).requires(Commands.subcommandPermission(COMMAND_NAME, pf))).executes(RemoteListCommand::execute));
    }

    private static int execute(CommandContext<CommandSourceStack> cc) {
        UserLogger log = UserLogger.ulog(cc);
        Commands.gitOp(Executor.ExecutionLock.NONE, log, repo -> {
            ArrayList<SnapshotId> snapshots = new ArrayList<SnapshotId>(repo.getRemoteSnapshots());
            Collections.sort(snapshots);
            snapshots.forEach(sid -> log.message(UserMessage.raw(sid.getShortName())));
            log.message(UserMessage.localized("fastback.chat.remote-list-done", snapshots.size(), repo.getConfig().getString(OtherConfigKey.REMOTE_PUSH_URL)));
        });
        return 1;
    }
}

