/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.pcal.fastback.commands.Command;
import net.pcal.fastback.commands.Commands;
import net.pcal.fastback.commands.PermissionsFactory;
import net.pcal.fastback.logging.UserLogger;
import net.pcal.fastback.logging.UserMessage;
import net.pcal.fastback.repo.SnapshotId;
import net.pcal.fastback.utils.Executor;

enum PruneCommand implements Command
{
    INSTANCE;

    private static final String COMMAND_NAME = "prune";

    @Override
    public void register(LiteralArgumentBuilder<CommandSourceStack> argb, PermissionsFactory<CommandSourceStack> pf) {
        argb.then(((LiteralArgumentBuilder)net.minecraft.commands.Commands.m_82127_((String)COMMAND_NAME).requires(Commands.subcommandPermission(COMMAND_NAME, pf))).executes(cc -> PruneCommand.prune((CommandSourceStack)cc.getSource())));
    }

    private static int prune(CommandSourceStack scs) {
        UserLogger ulog = UserLogger.ulog(scs);
        Commands.gitOp(Executor.ExecutionLock.WRITE, ulog, repo -> {
            Collection<SnapshotId> pruned = repo.doLocalPrune(ulog);
            if (pruned != null) {
                ulog.message(UserMessage.localized("fastback.chat.prune-done", pruned.size()));
                if (!pruned.isEmpty()) {
                    ulog.message(UserMessage.localized("fastback.chat.prune-suggest-gc", new Object[0]));
                }
            }
        });
        return 1;
    }
}

