/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.IOException;
import net.minecraft.commands.CommandSourceStack;
import net.pcal.fastback.commands.Command;
import net.pcal.fastback.commands.Commands;
import net.pcal.fastback.commands.PermissionsFactory;
import net.pcal.fastback.logging.SystemLogger;
import net.pcal.fastback.logging.UserLogger;
import net.pcal.fastback.logging.UserMessage;
import net.pcal.fastback.mod.Mod;
import net.pcal.fastback.utils.Executor;

enum FullCommand implements Command
{
    INSTANCE;

    private static final String COMMAND_NAME = "full";

    @Override
    public void register(LiteralArgumentBuilder<CommandSourceStack> argb, PermissionsFactory<CommandSourceStack> pf) {
        argb.then(((LiteralArgumentBuilder)net.minecraft.commands.Commands.m_82127_((String)COMMAND_NAME).requires(Commands.subcommandPermission(COMMAND_NAME, pf))).executes(cc -> FullCommand.run((CommandSourceStack)cc.getSource())));
    }

    public static int run(CommandSourceStack scs) {
        UserLogger ulog = UserLogger.ulog(scs);
        try {
            FullCommand.saveWorldBeforeBackup(ulog);
        }
        catch (IOException e) {
            ulog.internalError();
            SystemLogger.syslog().error(e);
        }
        Commands.gitOp(Executor.ExecutionLock.WRITE, ulog, repo -> repo.doCommitAndPush(ulog));
        return 1;
    }

    static void saveWorldBeforeBackup(UserLogger ulog) throws IOException {
        ulog.message(UserMessage.localized("fastback.chat.world-save", new Object[0]));
        Mod.mod().saveWorld();
        ulog.message(UserMessage.localized("fastback.message.backing-up", new Object[0]));
    }
}

