/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.util;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.jetbrains.annotations.Nullable;
import twilightforest.world.components.structures.util.AdvancementLockedStructure;
import twilightforest.world.components.structures.util.DecorationClearance;
import twilightforest.world.components.structures.util.LandmarkStructure;
import twilightforest.world.components.structures.util.StructureHints;

public abstract class ProgressionStructure
extends LandmarkStructure
implements AdvancementLockedStructure,
StructureHints {
    protected final AdvancementLockedStructure.AdvancementLockConfig advancementLockConfig;
    protected final StructureHints.HintConfig hintConfig;
    private long lastSpawnedHintMonsterTime;

    protected static <S extends ProgressionStructure> Products.P4<RecordCodecBuilder.Mu<S>, AdvancementLockedStructure.AdvancementLockConfig, StructureHints.HintConfig, DecorationClearance.DecorationConfig, Structure.StructureSettings> progressionCodec(RecordCodecBuilder.Instance<S> instance) {
        return instance.group((App)AdvancementLockedStructure.AdvancementLockConfig.CODEC.fieldOf("advancements_required").forGetter(s -> s.advancementLockConfig), (App)StructureHints.HintConfig.FLAT_CODEC.forGetter(s -> s.hintConfig)).and(ProgressionStructure.landmarkCodec(instance));
    }

    public ProgressionStructure(AdvancementLockedStructure.AdvancementLockConfig advancementLockConfig, StructureHints.HintConfig hintConfig, DecorationClearance.DecorationConfig decorationConfig, Structure.StructureSettings structureSettings) {
        super(decorationConfig, structureSettings);
        this.advancementLockConfig = advancementLockConfig;
        this.hintConfig = hintConfig;
    }

    @Override
    public List<ResourceLocation> getRequiredAdvancements() {
        return this.advancementLockConfig.requiredAdvancements();
    }

    @Override
    public void trySpawnHintMonster(Level world, Player player, BlockPos pos) {
        long currentTime = world.m_46467_();
        if (currentTime < this.lastSpawnedHintMonsterTime) {
            this.lastSpawnedHintMonsterTime = 0L;
        }
        if (currentTime - this.lastSpawnedHintMonsterTime > 1200L) {
            for (int i = 0; i < 20; ++i) {
                if (!this.didSpawnHintMonster(world, player, pos)) continue;
                this.lastSpawnedHintMonsterTime = currentTime;
                break;
            }
        }
    }

    @Override
    public ItemStack createHintBook() {
        return this.hintConfig.hintItem().m_41777_();
    }

    @Override
    @Nullable
    public Mob createHintMonster(Level world) {
        return (Mob)this.hintConfig.hintMob().m_20615_(world);
    }
}

