/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.placements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;
import twilightforest.init.TFLandmark;
import twilightforest.init.TFStructurePlacementTypes;
import twilightforest.util.LegacyLandmarkPlacements;
import twilightforest.world.components.chunkgenerators.ChunkGeneratorTwilight;

public class BiomeForcedLandmarkPlacement
extends StructurePlacement {
    public static final Codec<BiomeForcedLandmarkPlacement> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)TFLandmark.CODEC.fieldOf("landmark_set").forGetter(p -> p.landmark), (App)Codec.intRange((int)-32, (int)256).fieldOf("scan_elevation").forGetter(p -> p.scanHeight)).apply((Applicative)inst, BiomeForcedLandmarkPlacement::new));
    private final TFLandmark landmark;
    private final int scanHeight;

    public BiomeForcedLandmarkPlacement(TFLandmark landmark, int biomeScanHeight) {
        super(Vec3i.f_123288_, StructurePlacement.FrequencyReductionMethod.DEFAULT, 1.0f, 0, Optional.empty());
        this.landmark = landmark;
        this.scanHeight = biomeScanHeight;
    }

    public boolean isTFPlacementChunk(ChunkGenerator chunkGen, ChunkGeneratorStructureState state, int chunkX, int chunkZ) {
        if (chunkGen instanceof ChunkGeneratorTwilight) {
            ChunkGeneratorTwilight twilightGenerator = (ChunkGeneratorTwilight)chunkGen;
            return twilightGenerator.isLandmarkPickedForChunk(this.landmark, (Holder<Biome>)chunkGen.m_62218_().m_203407_(chunkX << 2, this.scanHeight, chunkZ << 2, state.m_255046_().m_224579_()), chunkX, chunkZ, state.m_254887_());
        }
        if (!LegacyLandmarkPlacements.chunkHasLandmarkCenter(chunkX, chunkZ)) {
            return false;
        }
        return LegacyLandmarkPlacements.pickVarietyLandmark(chunkX, chunkZ, state.m_254887_()) == this.landmark;
    }

    protected boolean m_214090_(ChunkGeneratorStructureState state, int chunkX, int chunkZ) {
        if (!LegacyLandmarkPlacements.chunkHasLandmarkCenter(chunkX, chunkZ)) {
            return false;
        }
        return LegacyLandmarkPlacements.pickVarietyLandmark(chunkX, chunkZ, state.m_254887_()) == this.landmark;
    }

    public StructurePlacementType<?> m_203443_() {
        return (StructurePlacementType)TFStructurePlacementTypes.FORCED_LANDMARK_PLACEMENT_TYPE.get();
    }

    public TFLandmark getLandmark() {
        return this.landmark;
    }
}

