/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import twilightforest.util.ArrayUtil;
import twilightforest.util.BoundingBoxUtils;

public abstract class TwilightTemplateStructurePiece
extends TemplateStructurePiece {
    protected final StructureTemplateManager structureManager;
    private final BlockPos originalPlacement;
    private final BoundingBox originalBox;

    public TwilightTemplateStructurePiece(StructurePieceType structurePieceType, CompoundTag compoundTag, StructurePieceSerializationContext ctx, StructurePlaceSettings rl2SettingsFunction) {
        super(structurePieceType, compoundTag, ctx.f_226956_(), rl -> rl2SettingsFunction);
        this.f_73379_ = this.m_6830_();
        this.f_73378_ = this.m_163587_();
        this.structureManager = ctx.f_226956_();
        this.originalPlacement = this.f_73658_;
        this.originalBox = BoundingBoxUtils.clone(this.f_73383_);
    }

    public TwilightTemplateStructurePiece(StructurePieceType type, int genDepth, StructureTemplateManager structureManager, ResourceLocation templateLocation, StructurePlaceSettings placeSettings, BlockPos startPosition) {
        super(type, genDepth, structureManager, templateLocation, templateLocation.toString(), placeSettings, startPosition);
        this.f_73379_ = this.m_6830_();
        this.f_73378_ = this.m_163587_();
        this.structureManager = structureManager;
        this.originalPlacement = this.f_73658_;
        this.originalBox = BoundingBoxUtils.clone(this.f_73383_);
    }

    protected void m_183620_(StructurePieceSerializationContext ctx, CompoundTag structureTag) {
        super.m_183620_(ctx, structureTag);
        structureTag.m_128405_("rotation", this.f_73657_.m_74404_().ordinal());
        structureTag.m_128405_("mirror", this.f_73657_.m_74401_().ordinal());
    }

    protected void placePieceAdjusted(WorldGenLevel level, StructureManager structureFeatureManager, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox boundingBox, ChunkPos chunkPos, BlockPos pos, int dY) {
        this.f_73658_ = this.f_73658_.m_6630_(dY);
        super.m_213694_(level, structureFeatureManager, chunkGenerator, random, boundingBox, chunkPos, pos.m_6630_(dY));
        this.f_73658_ = this.originalPlacement;
        this.f_73383_ = BoundingBoxUtils.clone(this.originalBox);
        this.f_73657_.m_74381_(this.f_73383_);
    }

    public static StructurePlaceSettings readSettings(CompoundTag compoundTag) {
        return new StructurePlaceSettings().m_74379_(ArrayUtil.wrapped(Rotation.values(), compoundTag.m_128451_("rotation"))).m_74377_(ArrayUtil.wrapped(Mirror.values(), compoundTag.m_128451_("mirror"))).m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74046_);
    }

    public static StructurePlaceSettings makeSettings(Rotation rotation) {
        return new StructurePlaceSettings().m_74379_(rotation).m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74046_);
    }

    public static StructurePlaceSettings makeSettings(Rotation rotation, Mirror mirror) {
        return new StructurePlaceSettings().m_74379_(rotation).m_74377_(mirror).m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74046_);
    }

    public static StructurePlaceSettings randomRotation(RandomSource random) {
        return TwilightTemplateStructurePiece.makeSettings(Rotation.m_221990_((RandomSource)random));
    }
}

