/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import org.jetbrains.annotations.NotNull;
import twilightforest.data.custom.stalactites.entry.Stalactite;
import twilightforest.init.TFEntities;
import twilightforest.init.TFLandmark;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.loot.TFLootTables;
import twilightforest.util.RectangleLatticeIterator;
import twilightforest.world.components.feature.BlockSpikeFeature;
import twilightforest.world.components.structures.TFStructureComponentOld;

public class HollowHillComponent
extends TFStructureComponentOld {
    private static final float SPACING = 3.75f;
    private static final float X_OFFSET = Mth.m_14089_((float)0.5235988f) * 3.75f;
    private static final float Z_OFFSET = Mth.m_14031_((float)0.5235988f) * 3.75f;
    private static final float X_SPACING = X_OFFSET * 2.0f;
    private static final float Z_SPACING = 3.75f;
    private static final float CHEST_SPAWN_CHANCE = 0.025f;
    private static final float SPAWNER_SPAWN_CHANCE = 0.025f;
    private static final float SPECIAL_SPAWN_CHANCE = 0.05f;
    private static final float ORE_STALACTITE_CHANCE = 0.85f;
    private final int hillSize;
    final int radius;
    final int hdiam;

    public HollowHillComponent(StructurePieceSerializationContext ctx, CompoundTag nbt) {
        this((StructurePieceType)TFStructurePieceTypes.TFHill.get(), nbt);
    }

    public HollowHillComponent(StructurePieceType piece, CompoundTag nbt) {
        super(piece, nbt);
        this.hillSize = nbt.m_128451_("hillSize");
        this.radius = (this.hillSize * 2 + 1) * 8 - 6;
        this.hdiam = (this.hillSize * 2 + 1) * 16;
    }

    public HollowHillComponent(StructurePieceType piece, int i, int size, int x, int y, int z) {
        super(piece, i, x, y, z);
        this.m_73519_(Direction.SOUTH);
        this.hillSize = size;
        this.radius = (this.hillSize * 2 + 1) * 8 - 6;
        this.hdiam = (this.hillSize * 2 + 1) * 16;
        this.f_73383_ = TFLandmark.getComponentToAddBoundingBox(x, y, z, -this.radius, -(3 + this.hillSize), -this.radius, this.radius * 2, this.radius / (this.hillSize == 1 ? 2 : this.hillSize), this.radius * 2, Direction.SOUTH, true);
    }

    @Override
    protected void m_183620_(StructurePieceSerializationContext ctx, CompoundTag tagCompound) {
        super.m_183620_(ctx, tagCompound);
        tagCompound.m_128405_("hillSize", this.hillSize);
    }

    public void m_213694_(WorldGenLevel world, StructureManager manager, ChunkGenerator generator, RandomSource rand, BoundingBox writeableBounds, ChunkPos chunkPosIn, BlockPos blockPos) {
        int distSq;
        BlockPos locatorPos = this.m_142171_();
        float shortenedRadiusSq = (float)(this.radius * this.radius) * 0.85f;
        for (BlockPos.MutableBlockPos latticePos : RectangleLatticeIterator.boundedGrid(writeableBounds, 0, X_SPACING, 3.75f, 0.0f, 0.0f)) {
            distSq = HollowHillComponent.getDistSqFromCenter(locatorPos, (BlockPos)latticePos);
            if ((float)distSq > shortenedRadiusSq) continue;
            this.setFeatures(world, rand, writeableBounds, latticePos, distSq);
        }
        for (BlockPos.MutableBlockPos latticePos : RectangleLatticeIterator.boundedGrid(writeableBounds, 0, X_SPACING, 3.75f, X_OFFSET, Z_OFFSET)) {
            distSq = HollowHillComponent.getDistSqFromCenter(locatorPos, (BlockPos)latticePos);
            if ((float)distSq > shortenedRadiusSq) continue;
            this.setFeatures(world, rand, writeableBounds, latticePos, distSq);
        }
    }

    private void setFeatures(WorldGenLevel world, RandomSource rand, BoundingBox writeableBounds, BlockPos.MutableBlockPos pos, int distSq) {
        rand.m_188584_(rand.m_188505_() ^ pos.m_121878_());
        this.placeCeilingFeature(world, rand, pos, distSq);
        this.placeFloorFeature(world, rand, writeableBounds, pos, distSq);
    }

    private void placeFloorFeature(WorldGenLevel world, RandomSource rand, BoundingBox writeableBounds, BlockPos.MutableBlockPos pos, int distSq) {
        int y = this.m_73544_(Mth.m_14143_((float)(this.getFloorHeight(Mth.m_14116_((float)distSq)) + 0.25f)));
        float floatChance = rand.m_188501_();
        if (floatChance < 0.05f) {
            float angle = rand.m_188501_() * ((float)Math.PI * 2);
            int x = Math.round(Mth.m_14089_((float)angle) * Mth.f_13994_) + pos.m_123341_();
            int z = Math.round(Mth.m_14031_((float)angle) * Mth.f_13994_) + pos.m_123343_();
            pos.m_122178_(x, y, z);
            if (floatChance < 0.025f) {
                HollowHillComponent.setSpawnerInWorld(world, writeableBounds, this.getMobID(rand), v -> {}, pos.m_7494_());
            } else {
                this.placeTreasureAtWorldPosition(world, this.getTreasureType(), false, writeableBounds, pos.m_7494_());
            }
            world.m_7731_(pos.m_7495_(), Blocks.f_50652_.m_49966_(), 50);
            world.m_7731_((BlockPos)pos, Blocks.f_50652_.m_49966_(), 50);
        } else {
            pos.m_142448_(y);
            BlockSpikeFeature.startSpike(world, (BlockPos)pos, BlockSpikeFeature.STONE_STALACTITE, rand, false);
        }
    }

    private void placeCeilingFeature(WorldGenLevel world, RandomSource rand, BlockPos.MutableBlockPos pos, int distSq) {
        BlockPos ceiling = pos.m_175288_(this.m_73544_(Mth.m_14167_((float)this.getCeilingHeight(Mth.m_14116_((float)distSq)))));
        Stalactite stalag = rand.m_188501_() < 0.85f ? BlockSpikeFeature.makeRandomOreStalactite(rand, this.hillSize) : BlockSpikeFeature.STONE_STALACTITE;
        BlockSpikeFeature.startSpike(world, ceiling, stalag, rand, true);
    }

    @NotNull
    private TFLootTables getTreasureType() {
        return this.hillSize == 3 ? TFLootTables.LARGE_HOLLOW_HILL : (this.hillSize == 2 ? TFLootTables.MEDIUM_HOLLOW_HILL : TFLootTables.SMALL_HOLLOW_HILL);
    }

    protected void generateOreStalactite(WorldGenLevel world, Vec3i pos, BoundingBox sbb) {
        this.generateOreStalactite(world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), sbb);
    }

    protected void generateOreStalactite(WorldGenLevel world, int x, int y, int z, BoundingBox sbb) {
        int dz;
        int dy;
        int dx = this.m_73392_(x, z);
        BlockPos pos = new BlockPos(dx, dy = this.m_73544_(y), dz = this.m_73525_(x, z));
        if (sbb.m_71051_((Vec3i)pos) && world.m_8055_(pos).m_60734_() != Blocks.f_50085_) {
            RandomSource stalRNG = RandomSource.m_216335_((long)(world.m_7328_() + (long)dx * (long)dz));
            Stalactite stalag = BlockSpikeFeature.makeRandomOreStalactite(stalRNG, this.hillSize);
            BlockSpikeFeature.startSpike(world, pos, stalag, stalRNG, true);
        }
    }

    protected void generateBlockSpike(WorldGenLevel world, Stalactite config, int x, int y, int z, BoundingBox sbb, boolean hanging) {
        int dz;
        int dy;
        int dx = this.m_73392_(x, z);
        BlockPos pos = new BlockPos(dx, dy = this.m_73544_(y), dz = this.m_73525_(x, z));
        if (sbb.m_71051_((Vec3i)pos) && world.m_8055_(pos).m_60734_() != Blocks.f_50085_) {
            RandomSource stalRNG = RandomSource.m_216335_((long)(world.m_7328_() + (long)dx * (long)dz));
            BlockSpikeFeature.startSpike(world, pos, config, stalRNG, hanging);
        }
    }

    boolean isInHill(int cx, int cz) {
        int dx = this.radius - cx;
        int dz = this.radius - cz;
        return Mth.m_14116_((float)(dx * dx + dz * dz)) < (float)this.radius;
    }

    @Deprecated
    int[] randomCoordinatesInHill2D(RandomSource rand) {
        return this.randomCoordinatesInHill2D(rand, this.radius);
    }

    @Deprecated
    int[] randomCoordinatesInHill2D(RandomSource rand, int maximumRadius) {
        BlockPos.MutableBlockPos pos = this.randomFloorCoordinates(rand, maximumRadius);
        return new int[]{pos.m_123341_(), pos.m_123343_()};
    }

    BlockPos.MutableBlockPos randomFloorCoordinates(RandomSource rand, float maximumRadius) {
        float degree = rand.m_188501_() * ((float)Math.PI * 2);
        float radius = rand.m_188501_() * 0.9f * maximumRadius;
        float dist = Mth.m_14116_((float)(radius * radius));
        float height = this.getFloorHeight(dist);
        return new BlockPos.MutableBlockPos((double)(maximumRadius - Mth.m_14089_((float)degree) * radius), (double)height, (double)(maximumRadius - Mth.m_14031_((float)degree) * radius));
    }

    private float getFloorHeight(float dist) {
        return (float)(this.hillSize * 2) - Mth.m_14089_((float)(dist / (float)this.hdiam * (float)Math.PI)) * ((float)this.hdiam / 20.0f) + 1.0f;
    }

    BlockPos.MutableBlockPos randomCeilingCoordinates(RandomSource rand, float maximumRadius) {
        float degree = rand.m_188501_() * ((float)Math.PI * 2);
        float radius = rand.m_188501_() * 0.9f * maximumRadius;
        float dist = Mth.m_14116_((float)(radius * radius));
        float height = this.getCeilingHeight(dist);
        return new BlockPos.MutableBlockPos((double)(maximumRadius - Mth.m_14089_((float)degree) * radius), (double)height, (double)(maximumRadius - Mth.m_14031_((float)degree) * radius));
    }

    private float getCeilingHeight(float dist) {
        return Mth.m_14089_((float)(dist / (float)this.hdiam * (float)Math.PI)) * ((float)this.hdiam / 4.0f);
    }

    protected EntityType<?> getMobID(RandomSource rand) {
        return this.getMobID(rand, this.hillSize);
    }

    protected EntityType<?> getMobID(RandomSource rand, int level) {
        if (level == 1) {
            return this.getLevel1Mob(rand);
        }
        if (level == 2) {
            return this.getLevel2Mob(rand);
        }
        if (level == 3) {
            return this.getLevel3Mob(rand);
        }
        return EntityType.f_20479_;
    }

    public EntityType<?> getLevel1Mob(RandomSource rand) {
        return switch (rand.m_188503_(10)) {
            case 3, 4, 5 -> EntityType.f_20479_;
            case 6, 7 -> EntityType.f_20501_;
            case 8 -> EntityType.f_20523_;
            case 9 -> (EntityType)TFEntities.REDCAP.get();
            default -> (EntityType)TFEntities.SWARM_SPIDER.get();
        };
    }

    public EntityType<?> getLevel2Mob(RandomSource rand) {
        return switch (rand.m_188503_(10)) {
            case 3, 4, 5 -> EntityType.f_20501_;
            case 6, 7 -> EntityType.f_20524_;
            case 8 -> (EntityType)TFEntities.SWARM_SPIDER.get();
            case 9 -> EntityType.f_20554_;
            default -> (EntityType)TFEntities.REDCAP.get();
        };
    }

    public EntityType<?> getLevel3Mob(RandomSource rand) {
        return switch (rand.m_188503_(11)) {
            case 0 -> (EntityType)TFEntities.SLIME_BEETLE.get();
            case 1 -> (EntityType)TFEntities.FIRE_BEETLE.get();
            case 2 -> (EntityType)TFEntities.PINCH_BEETLE.get();
            case 3, 4, 5 -> EntityType.f_20524_;
            case 6, 7, 8 -> EntityType.f_20554_;
            case 9 -> EntityType.f_20558_;
            default -> (EntityType)TFEntities.WRAITH.get();
        };
    }

    public static int getDistSqFromCenter(BlockPos center, BlockPos to) {
        int x = to.m_123341_() - center.m_123341_();
        int z = to.m_123343_() - center.m_123343_();
        return x * x + z * z;
    }
}

