/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.templates;

import com.mojang.serialization.Codec;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import twilightforest.TwilightForestMod;
import twilightforest.init.TFEntities;
import twilightforest.loot.TFLootTables;
import twilightforest.util.EntityUtil;
import twilightforest.world.components.feature.config.SwizzleConfig;
import twilightforest.world.components.feature.templates.TemplateFeature;
import twilightforest.world.components.processors.CobbleVariants;
import twilightforest.world.components.processors.StoneBricksVariants;

public class DruidHutFeature
extends TemplateFeature<SwizzleConfig> {
    public DruidHutFeature(Codec<SwizzleConfig> config) {
        super(config);
    }

    @Override
    protected StructureTemplate getTemplate(StructureTemplateManager templateManager, RandomSource random) {
        return templateManager.m_230359_(((HutType)((Object)Util.m_214670_((Object[])HutType.values(), (RandomSource)random))).resourceLocation);
    }

    @Override
    protected void modifySettings(StructurePlaceSettings settings, RandomSource random, SwizzleConfig config) {
        config.buildAddProcessors(settings, random);
    }

    @Override
    protected void postPlacement(WorldGenLevel world, RandomSource random, StructureTemplateManager templateManager, Rotation rotation, Mirror mirror, StructurePlaceSettings placementSettings, BlockPos placementPos, SwizzleConfig config) {
        if (random.m_188499_()) {
            StructureTemplate template = templateManager.m_230359_(BasementType.values()[random.m_188503_(BasementType.size)].getBasement(random.m_188499_()));
            if (template == null) {
                return;
            }
            placementPos = placementPos.m_6625_(12).m_5484_(rotation.m_55954_(mirror.m_54848_(Direction.NORTH)), 1).m_5484_(rotation.m_55954_(mirror.m_54848_(Direction.EAST)), 1);
            placementSettings.m_74394_();
            config.buildAddProcessors(placementSettings, random);
            placementSettings.m_74383_((StructureProcessor)CobbleVariants.INSTANCE).m_74383_((StructureProcessor)StoneBricksVariants.INSTANCE);
            template.m_230328_((ServerLevelAccessor)world, placementPos, placementPos, placementSettings, random, 20);
            for (StructureTemplate.StructureBlockInfo info : template.m_74603_(placementPos, placementSettings, Blocks.f_50677_)) {
                if (info.f_74677_() == null || StructureMode.valueOf((String)info.f_74677_().m_128461_("mode")) != StructureMode.DATA) continue;
                this.processMarkers(info, world, rotation, mirror, random);
            }
        }
    }

    @Override
    protected void processMarkers(StructureTemplate.StructureBlockInfo info, WorldGenLevel world, Rotation rotation, Mirror mirror, RandomSource random) {
        String s = info.f_74677_().m_128461_("metadata");
        BlockPos blockPos = info.f_74675_();
        if ("spawner".equals(s)) {
            BlockEntity tile;
            if (world.m_7471_(blockPos, false) && world.m_7731_(blockPos, Blocks.f_50085_.m_49966_(), 18) && (tile = world.m_7702_(blockPos)) instanceof SpawnerBlockEntity) {
                SpawnerBlockEntity ms = (SpawnerBlockEntity)tile;
                ms.m_252803_((EntityType)TFEntities.SKELETON_DRUID.get(), random);
            }
        } else if (s.startsWith("loot")) {
            world.m_7471_(blockPos, false);
            BlockState chest = s.endsWith("T") ? Blocks.f_50325_.m_49966_() : Blocks.f_50087_.m_49966_();
            chest = switch (s.substring(5, 6)) {
                case "L" -> (BlockState)chest.m_61124_((Property)ChestBlock.f_51479_, (Comparable)(mirror != Mirror.NONE ? ChestType.RIGHT : ChestType.LEFT));
                case "R" -> (BlockState)chest.m_61124_((Property)ChestBlock.f_51479_, (Comparable)(mirror != Mirror.NONE ? ChestType.LEFT : ChestType.RIGHT));
                default -> (BlockState)chest.m_61124_((Property)ChestBlock.f_51479_, (Comparable)ChestType.SINGLE);
            };
            chest = switch (s.substring(4, 5)) {
                case "W" -> (BlockState)chest.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)rotation.m_55954_(mirror.m_54848_(Direction.WEST)));
                case "E" -> (BlockState)chest.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)rotation.m_55954_(mirror.m_54848_(Direction.EAST)));
                case "S" -> (BlockState)chest.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)rotation.m_55954_(mirror.m_54848_(Direction.SOUTH)));
                default -> (BlockState)chest.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)rotation.m_55954_(mirror.m_54848_(Direction.NORTH)));
            };
            TFLootTables.BASEMENT.generateLootContainer(world, blockPos, chest, 18);
        } else if (s.startsWith("painting")) {
            world.m_7471_(blockPos, false);
            Direction direction = rotation.m_55954_(mirror.m_54848_(switch (s.substring(8, 9)) {
                case "W" -> Direction.WEST;
                case "E" -> Direction.EAST;
                case "S" -> Direction.SOUTH;
                default -> Direction.NORTH;
            }));
            String widthS = s.substring(9, 10);
            int paintingWidth = widthS.matches("\\d+") ? Integer.parseInt(widthS) << 4 : 16;
            boolean hasFlipped = mirror != Mirror.NONE;
            BlockPos hangPos = hasFlipped ? blockPos.m_121945_(direction.m_122427_()) : blockPos;
            EntityUtil.tryHangPainting(world, hangPos, direction, EntityUtil.getPaintingOfSize(random, paintingWidth, paintingWidth == 32 || paintingWidth == 64 ? 32 : 16, true));
        }
    }

    private static enum HutType {
        REGULAR(TwilightForestMod.prefix("feature/druid_hut/druid_hut")),
        SIDEWAYS(TwilightForestMod.prefix("feature/druid_hut/druid_sideways")),
        DOUBLE_DECK(TwilightForestMod.prefix("feature/druid_hut/druid_doubledeck"));

        private final ResourceLocation resourceLocation;

        private HutType(ResourceLocation rl) {
            this.resourceLocation = rl;
        }
    }

    private static enum BasementType {
        STUDY(TwilightForestMod.prefix("feature/druid_hut/basement_study"), TwilightForestMod.prefix("feature/druid_hut/basement_study_trap")),
        SHELVES(TwilightForestMod.prefix("feature/druid_hut/basement_shelves"), TwilightForestMod.prefix("feature/druid_hut/basement_shelves_trap")),
        GALLERY(TwilightForestMod.prefix("feature/druid_hut/basement_gallery"), TwilightForestMod.prefix("feature/druid_hut/basement_gallery_trap"));

        private final ResourceLocation resourceLocation;
        private final ResourceLocation resourceLocationTrap;
        private static int size;

        private BasementType(ResourceLocation rl, ResourceLocation rlTrap) {
            this.resourceLocation = rl;
            this.resourceLocationTrap = rlTrap;
            BasementType.increment();
        }

        private static void increment() {
            ++size;
        }

        private ResourceLocation getBasement(boolean trapped) {
            return trapped ? this.resourceLocationTrap : this.resourceLocation;
        }
    }
}

