/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.projectile;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.enchantment.ChillAuraEnchantment;
import twilightforest.entity.boss.AlphaYeti;
import twilightforest.entity.monster.Yeti;
import twilightforest.entity.projectile.TFThrowable;
import twilightforest.init.TFDamageTypes;
import twilightforest.init.TFEntities;

public class IceBomb
extends TFThrowable {
    private int zoneTimer = 80;
    private boolean hasHit;

    public IceBomb(EntityType<? extends IceBomb> type, Level world) {
        super(type, world);
    }

    public IceBomb(EntityType<? extends IceBomb> type, Level world, LivingEntity thrower) {
        super(type, world, thrower);
    }

    public IceBomb(Level world, Position pos) {
        super((EntityType<? extends TFThrowable>)((EntityType)TFEntities.THROWN_ICE.get()), world, pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
    }

    protected void m_6532_(HitResult result) {
        this.m_20334_(0.0, 0.0, 0.0);
        this.hasHit = true;
        this.doTerrainEffects();
    }

    private void doTerrainEffects() {
        int range = 3;
        int ix = Mth.m_14107_((double)this.f_19790_);
        int iy = Mth.m_14107_((double)this.f_19791_);
        int iz = Mth.m_14107_((double)this.f_19792_);
        for (int x = -3; x <= 3; ++x) {
            for (int y = -3; y <= 3; ++y) {
                for (int z = -3; z <= 3; ++z) {
                    BlockPos pos = new BlockPos(ix + x, iy + y, iz + z);
                    this.doTerrainEffect(pos);
                }
            }
        }
    }

    private void doTerrainEffect(BlockPos pos) {
        BlockState state = this.m_9236_().m_8055_(pos);
        if (!this.m_9236_().m_5776_()) {
            if (state.m_60713_(Blocks.f_49990_)) {
                this.m_9236_().m_46597_(pos, Blocks.f_50126_.m_49966_());
            }
            if (state == Blocks.f_49991_.m_49966_()) {
                this.m_9236_().m_46597_(pos, Blocks.f_50080_.m_49966_());
            }
            if (this.m_9236_().m_46859_(pos) && Blocks.f_50125_.m_49966_().m_60710_((LevelReader)this.m_9236_(), pos)) {
                this.m_9236_().m_46597_(pos, Blocks.f_50125_.m_49966_());
            }
            if (state.m_204336_(BlockTagGenerator.ICE_BOMB_REPLACEABLES)) {
                this.m_9236_().m_7731_(pos, Blocks.f_50125_.m_49966_().m_60710_((LevelReader)this.m_9236_(), pos) ? Blocks.f_50125_.m_49966_() : Blocks.f_50016_.m_49966_(), 3);
            }
            if (state.m_60713_(Blocks.f_50125_) && (Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_) < 8) {
                this.m_9236_().m_46597_(pos, (BlockState)state.m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_) + 1)));
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.hasHit) {
            this.m_20184_().m_82542_(0.1, 0.1, 0.1);
            --this.zoneTimer;
            this.makeIceZone();
            if (!this.m_9236_().m_5776_() && this.zoneTimer <= 0) {
                this.m_9236_().m_46796_(2001, new BlockPos((Vec3i)this.m_20183_()), Block.m_49956_((BlockState)Blocks.f_50126_.m_49966_()));
                this.m_146870_();
            }
        } else {
            this.makeTrail((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, Blocks.f_50125_.m_49966_()), this.m_19749_() instanceof AlphaYeti ? 2 : 5);
        }
    }

    private void makeIceZone() {
        if (this.m_9236_().m_5776_()) {
            BlockState stateId = Blocks.f_50125_.m_49966_();
            for (int i = 0; i < 15; ++i) {
                double dx = this.m_20185_() + (double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 3.0f);
                double dy = this.m_20186_() + (double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 3.0f);
                double dz = this.m_20189_() + (double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 3.0f);
                this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, stateId), dx, dy, dz, 0.0, 0.0, 0.0);
            }
        } else if (this.zoneTimer % 20 == 0) {
            this.hitNearbyEntities();
        }
    }

    private void hitNearbyEntities() {
        List nearby = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(3.0, 2.0, 3.0));
        for (LivingEntity entity : nearby) {
            if (entity == this.m_19749_()) continue;
            if (entity instanceof Yeti) {
                BlockPos pos = BlockPos.m_274561_((double)entity.f_19790_, (double)entity.f_19791_, (double)entity.f_19792_);
                this.m_9236_().m_46597_(pos, Blocks.f_50126_.m_49966_());
                this.m_9236_().m_46597_(pos.m_7494_(), Blocks.f_50126_.m_49966_());
                entity.m_146870_();
                continue;
            }
            if (entity.m_6095_().m_204039_(EntityTypeTags.f_144294_)) continue;
            entity.m_6469_(TFDamageTypes.getIndirectEntityDamageSource(this.m_9236_(), TFDamageTypes.FROZEN, (Entity)this, this.m_19749_(), new EntityType[0]), entity.m_6095_().m_204039_(EntityTypeTags.f_144295_) ? 5.0f : 1.0f);
            ChillAuraEnchantment.doChillAuraEffect(entity, 100, 0, true);
        }
    }

    public BlockState getBlockState() {
        return Blocks.f_50354_.m_49966_();
    }

    protected float m_7139_() {
        return this.hasHit ? 0.0f : 0.025f;
    }
}

