/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.DetectedVersion;
import net.minecraft.WorldVersion;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import twilightforest.data.AtlasGenerator;
import twilightforest.data.BlockstateGenerator;
import twilightforest.data.CraftingGenerator;
import twilightforest.data.ItemModelGenerator;
import twilightforest.data.LangGenerator;
import twilightforest.data.LootGenerator;
import twilightforest.data.LootModifierGenerator;
import twilightforest.data.RegistryDataGenerator;
import twilightforest.data.SoundGenerator;
import twilightforest.data.TFAdvancementProvider;
import twilightforest.data.custom.CrumbleHornGenerator;
import twilightforest.data.custom.TransformationPowderGenerator;
import twilightforest.data.custom.stalactites.StalactiteGenerator;
import twilightforest.data.tags.BiomeTagGenerator;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.data.tags.CustomTagGenerator;
import twilightforest.data.tags.DamageTypeTagGenerator;
import twilightforest.data.tags.EntityTagGenerator;
import twilightforest.data.tags.FluidTagGenerator;
import twilightforest.data.tags.ItemTagGenerator;
import twilightforest.data.tags.StructureTagGenerator;

@Mod.EventBusSubscriber(modid="twilightforest", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = event.getGenerator().getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        DataGenerators.addArmorTrims(helper);
        generator.addProvider(event.includeServer(), (DataProvider)new TFAdvancementProvider(output, provider, helper));
        generator.addProvider(event.includeClient(), (DataProvider)new BlockstateGenerator(output, helper));
        generator.addProvider(event.includeClient(), (DataProvider)new ItemModelGenerator(output, helper));
        generator.addProvider(event.includeClient(), (DataProvider)new SoundGenerator(output, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new CustomTagGenerator.BannerPatternTagGenerator(output, provider, helper));
        BlockTagGenerator blocktags = new BlockTagGenerator(output, provider, helper);
        generator.addProvider(event.includeServer(), (DataProvider)blocktags);
        generator.addProvider(event.includeServer(), (DataProvider)new CustomTagGenerator.BlockEntityTagGenerator(output, provider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new FluidTagGenerator(output, provider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new ItemTagGenerator(output, provider, blocktags.m_274426_(), helper));
        generator.addProvider(event.includeServer(), (DataProvider)new EntityTagGenerator(output, provider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new CustomTagGenerator.EnchantmentTagGenerator(output, provider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new LootGenerator(output));
        generator.addProvider(event.includeServer(), (DataProvider)new CraftingGenerator(output));
        generator.addProvider(event.includeServer(), (DataProvider)new LootModifierGenerator(output));
        RegistryDataGenerator datapackProvider = new RegistryDataGenerator(output, provider);
        CompletableFuture lookupProvider = datapackProvider.getRegistryProvider();
        generator.addProvider(event.includeServer(), (DataProvider)datapackProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new CustomTagGenerator.WoodPaletteTagGenerator(output, lookupProvider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new BiomeTagGenerator(output, lookupProvider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new DamageTypeTagGenerator(output, lookupProvider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new StructureTagGenerator(output, lookupProvider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new CrumbleHornGenerator(output, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new TransformationPowderGenerator(output, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new StalactiteGenerator(output));
        generator.addProvider(true, (DataProvider)new PackMetadataGenerator(output).m_247300_(PackMetadataSection.f_243696_, (Object)new PackMetadataSection((Component)Component.m_237113_((String)"Resources for Twilight Forest"), DetectedVersion.f_132476_.m_264084_(PackType.CLIENT_RESOURCES), Arrays.stream(PackType.values()).collect(Collectors.toMap(Function.identity(), arg_0 -> ((WorldVersion)DetectedVersion.f_132476_).m_264084_(arg_0))))));
        generator.addProvider(event.includeClient(), (DataProvider)new AtlasGenerator(output, helper));
        generator.addProvider(event.includeClient(), (DataProvider)new LangGenerator(output));
    }

    private static void addArmorTrims(ExistingFileHelper existingFileHelper) {
        for (ItemModelGenerators.TrimModelData trim : ItemModelGenerators.f_265952_) {
            existingFileHelper.trackGenerated(new ResourceLocation("boots_trim_" + trim.f_265890_()), PackType.CLIENT_RESOURCES, ".png", "textures/trims/items");
            existingFileHelper.trackGenerated(new ResourceLocation("chestplate_trim_" + trim.f_265890_()), PackType.CLIENT_RESOURCES, ".png", "textures/trims/items");
            existingFileHelper.trackGenerated(new ResourceLocation("helmet_trim_" + trim.f_265890_()), PackType.CLIENT_RESOURCES, ".png", "textures/trims/items");
            existingFileHelper.trackGenerated(new ResourceLocation("leggings_trim_" + trim.f_265890_()), PackType.CLIENT_RESOURCES, ".png", "textures/trims/items");
        }
    }
}

