/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat.curios;

import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;
import top.theillusivec4.curios.api.event.DropRulesEvent;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.common.capability.CurioItemCapability;
import twilightforest.client.model.TFModelLayers;
import twilightforest.compat.curios.model.CharmOfLifeNecklaceModel;
import twilightforest.compat.curios.renderer.CharmOfKeepingRenderer;
import twilightforest.compat.curios.renderer.CharmOfLifeNecklaceRenderer;
import twilightforest.compat.curios.renderer.CurioHeadRenderer;
import twilightforest.events.CharmEvents;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFItems;
import twilightforest.item.SkullCandleItem;
import twilightforest.item.TrophyItem;
import twilightforest.network.CreateMovingCicadaSoundPacket;
import twilightforest.network.TFPacketHandler;

public class CuriosCompat {
    public static ICapabilityProvider setupCuriosCapability(final ItemStack stack) {
        return CurioItemCapability.createProvider((ICurio)new ICurio(){

            public ItemStack getStack() {
                return stack;
            }

            @Nonnull
            public ICurio.SoundInfo getEquipSound(SlotContext slotContext) {
                return new ICurio.SoundInfo(SoundEvents.f_11675_, 1.0f, 1.0f);
            }

            public void onEquip(SlotContext context, ItemStack prevStack) {
                if (!context.entity().m_6844_(EquipmentSlot.HEAD).m_150930_(((Block)TFBlocks.CICADA.get()).m_5456_()) && stack.m_150930_(((Block)TFBlocks.CICADA.get()).m_5456_()) && !context.entity().m_9236_().m_5776_()) {
                    TFPacketHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> ((SlotContext)context).entity()), (Object)new CreateMovingCicadaSoundPacket(context.entity().m_19879_()));
                }
            }

            public boolean canEquipFromUse(SlotContext slotContext) {
                return true;
            }
        });
    }

    public static void keepCurios(DropRulesEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            CompoundTag playerData = CharmEvents.getPlayerData(player);
            if (!player.m_9236_().m_5776_() && CharmEvents.charmUsed != null && playerData.m_128441_("TFCharmInventory") && !playerData.m_128437_("TFCharmInventory", 10).isEmpty()) {
                CuriosApi.getCuriosHelper().getEquippedCurios((LivingEntity)player).ifPresent(modifiable -> {
                    int i = 0;
                    while (i < modifiable.getSlots()) {
                        int finalI = i++;
                        event.addOverride(stack -> stack == modifiable.getStackInSlot(finalI), ICurio.DropRule.ALWAYS_KEEP);
                    }
                });
            }
        }
    }

    public static void registerCurioLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(TFModelLayers.CHARM_OF_LIFE, CharmOfLifeNecklaceModel::create);
    }

    public static void registerCurioRenderers(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            CuriosRendererRegistry.register((Item)((Item)TFItems.CHARM_OF_LIFE_1.get()), () -> new CharmOfLifeNecklaceRenderer(new float[]{1.0f, 0.5f, 0.5f}));
            CuriosRendererRegistry.register((Item)((Item)TFItems.CHARM_OF_LIFE_2.get()), () -> new CharmOfLifeNecklaceRenderer(new float[]{1.0f, 0.9f, 0.0f}));
            CuriosRendererRegistry.register((Item)((Item)TFItems.CHARM_OF_KEEPING_1.get()), CharmOfKeepingRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)TFItems.CHARM_OF_KEEPING_2.get()), CharmOfKeepingRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)TFItems.CHARM_OF_KEEPING_3.get()), CharmOfKeepingRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)TFItems.NAGA_TROPHY.get()), CurioHeadRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)TFItems.LICH_TROPHY.get()), CurioHeadRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)TFItems.MINOSHROOM_TROPHY.get()), CurioHeadRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)TFItems.HYDRA_TROPHY.get()), CurioHeadRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)TFItems.KNIGHT_PHANTOM_TROPHY.get()), CurioHeadRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)TFItems.UR_GHAST_TROPHY.get()), CurioHeadRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)TFItems.ALPHA_YETI_TROPHY.get()), CurioHeadRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)TFItems.SNOW_QUEEN_TROPHY.get()), CurioHeadRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)TFItems.QUEST_RAM_TROPHY.get()), CurioHeadRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)TFItems.CICADA.get()), CurioHeadRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)TFItems.FIREFLY.get()), CurioHeadRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)TFItems.MOONWORM.get()), CurioHeadRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)TFItems.CREEPER_SKULL_CANDLE.get()), CurioHeadRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)TFItems.PIGLIN_SKULL_CANDLE.get()), CurioHeadRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)TFItems.PLAYER_SKULL_CANDLE.get()), CurioHeadRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)TFItems.SKELETON_SKULL_CANDLE.get()), CurioHeadRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)TFItems.WITHER_SKELETON_SKULL_CANDLE.get()), CurioHeadRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)TFItems.ZOMBIE_SKULL_CANDLE.get()), CurioHeadRenderer::new);
        });
    }

    public static boolean isCicadaEquipped(LivingEntity entity) {
        Optional slot = CuriosApi.getCuriosHelper().findFirstCurio(entity, stack -> stack.m_150930_((Item)TFItems.CICADA.get()));
        return slot.isPresent();
    }

    public static boolean isTrophyCurioEquipped(LivingEntity entity) {
        Optional slot = CuriosApi.getCuriosHelper().findFirstCurio(entity, stack -> stack.m_41720_() instanceof TrophyItem);
        return slot.isPresent() && ((SlotResult)slot.get()).slotContext() != null && ((SlotResult)slot.get()).slotContext().visible();
    }

    public static boolean isSkullCurioEquipped(LivingEntity entity) {
        Optional slot = CuriosApi.getCuriosHelper().findFirstCurio(entity, stack -> stack.m_41720_() instanceof SkullCandleItem);
        return slot.isPresent() && ((SlotResult)slot.get()).slotContext() != null && ((SlotResult)slot.get()).slotContext().visible();
    }
}

