/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import twilightforest.TwilightForestMod;
import twilightforest.client.model.entity.NagaModel;
import twilightforest.entity.boss.Naga;

public class NagaRenderer<M extends NagaModel<Naga>>
extends MobRenderer<Naga, M> {
    private static final ResourceLocation textureLoc = TwilightForestMod.getModelTexture("nagahead.png");
    private static final ResourceLocation textureLocCharging = TwilightForestMod.getModelTexture("nagahead_charging.png");

    public NagaRenderer(EntityRendererProvider.Context manager, M model, float shadowSize) {
        super(manager, model, shadowSize);
        this.m_115326_(new NagaEyelidsLayer(this));
    }

    protected void scale(Naga entity, PoseStack stack, float partialTicks) {
        super.m_7546_((LivingEntity)entity, stack, partialTicks);
        stack.m_85841_(2.01f, 2.01f, 2.01f);
        stack.m_252880_(0.0f, entity.isDazed() ? 1.075f : 0.75f, entity.isDazed() ? 0.175f : 0.0f);
    }

    protected float getFlipDegrees(Naga naga) {
        return naga.m_21224_() ? 0.0f : super.m_6441_((LivingEntity)naga);
    }

    public ResourceLocation getTextureLocation(Naga entity) {
        if (entity.isCharging() || entity.m_21224_()) {
            return textureLocCharging;
        }
        return textureLoc;
    }

    public static class NagaEyelidsLayer<T extends Naga, M extends NagaModel<T>>
    extends RenderLayer<T, M> {
        private static final ResourceLocation textureLocDazed = TwilightForestMod.getModelTexture("nagahead_dazed.png");

        public NagaEyelidsLayer(RenderLayerParent<T, M> renderer) {
            super(renderer);
        }

        public void render(PoseStack stack, MultiBufferSource buffer, int light, T naga, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (((Naga)naga).isDazed()) {
                VertexConsumer vertex = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)textureLocDazed));
                ((NagaModel)this.m_117386_()).m_7695_(stack, vertex, light, OverlayTexture.m_118090_((float)0.0f, (((Naga)naga).f_20916_ > 0 ? 1 : 0) != 0), 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }
}

