/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;
import twilightforest.TFConfig;
import twilightforest.block.CloudBlock;
import twilightforest.client.renderer.TFWeatherRenderer;
import twilightforest.util.Vec2i;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="twilightforest", value={Dist.CLIENT})
public class CloudEvents {
    private static final List<PrecipitationRenderHelper> RENDER_HELPER = new ArrayList<PrecipitationRenderHelper>();

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (!mc.m_91104_() && mc.f_91073_ != null && TFConfig.getClientCloudBlockPrecipitationDistance() > 0) {
            Vec3 vec3 = mc.f_91063_.m_109153_().m_90583_();
            if (mc.f_91073_.m_46467_() % 10L == 0L) {
                RENDER_HELPER.clear();
                double camX = vec3.m_7096_();
                double camY = vec3.m_7098_();
                double camZ = vec3.m_7094_();
                int floorX = Mth.m_14107_((double)camX);
                int floorY = Mth.m_14107_((double)camY);
                int floorZ = Mth.m_14107_((double)camZ);
                int renderDistance = Minecraft.m_91405_() ? 10 : 5;
                int precipitationDistance = TFConfig.getClientCloudBlockPrecipitationDistance();
                for (int roofZ = floorZ - renderDistance; roofZ <= floorZ + renderDistance; ++roofZ) {
                    for (int roofX = floorX - renderDistance; roofX <= floorX + renderDistance; ++roofX) {
                        int lastBadYLevel = Integer.MIN_VALUE;
                        for (int roofY = floorY - renderDistance; roofY < floorY + precipitationDistance + renderDistance; ++roofY) {
                            CloudBlock cloudBlock;
                            Pair<Biome.Precipitation, Float> precipitationRainLevelPair;
                            Block block;
                            boolean skipLoop = roofY == lastBadYLevel + 1;
                            BlockPos pos = new BlockPos(roofX, roofY, roofZ);
                            if (Heightmap.Types.MOTION_BLOCKING.m_64299_().test(mc.f_91073_.m_8055_(pos))) {
                                lastBadYLevel = roofY;
                            }
                            if (skipLoop || !((block = mc.f_91073_.m_8055_(pos).m_60734_()) instanceof CloudBlock) || (precipitationRainLevelPair = (cloudBlock = (CloudBlock)block).getCurrentPrecipitation(pos, (Level)mc.f_91073_, mc.f_91073_.m_46722_(1.0f))).getLeft() == Biome.Precipitation.NONE) continue;
                            int highestRainyBlock = roofY;
                            int y = roofY - 1;
                            while (y > roofY - precipitationDistance && !Heightmap.Types.MOTION_BLOCKING.m_64299_().test(mc.f_91073_.m_8055_(pos.m_175288_(y)))) {
                                highestRainyBlock = y--;
                            }
                            if (highestRainyBlock == roofY) continue;
                            RENDER_HELPER.add(new PrecipitationRenderHelper(pos, (Biome.Precipitation)precipitationRainLevelPair.getLeft(), ((Float)precipitationRainLevelPair.getRight()).floatValue(), highestRainyBlock));
                        }
                    }
                }
            }
            RandomSource randomsource = RandomSource.m_216335_((long)((long)mc.f_91060_.getTicks() * 312987231L));
            BlockPos particlePos = null;
            int particleCount = 100 / (mc.f_91066_.m_231929_().m_231551_() == ParticleStatus.DECREASED ? 2 : 1);
            boolean yetToMakeASound = true;
            BlockPos camPos = BlockPos.m_274446_((Position)vec3);
            ArrayList<Vec2i> particleChecks = new ArrayList<Vec2i>();
            for (int i = 0; i < particleCount; ++i) {
                particleChecks.add(new Vec2i(randomsource.m_188503_(21) - 10 + camPos.m_123341_(), randomsource.m_188503_(21) - 10 + camPos.m_123343_()));
            }
            block5: for (PrecipitationRenderHelper helper : RENDER_HELPER) {
                if (helper.precipitation() != Biome.Precipitation.RAIN) continue;
                for (Vec2i vec2 : particleChecks) {
                    if (vec2.x != helper.cloudPos().m_123341_() || vec2.z != helper.cloudPos().m_123343_()) continue;
                    BlockPos highestRainyPos = helper.cloudPos().m_175288_(helper.rainOnY());
                    if (!Heightmap.Types.MOTION_BLOCKING.m_64299_().test(mc.f_91073_.m_8055_(highestRainyPos.m_7495_()))) continue;
                    if (yetToMakeASound && particlePos != null && randomsource.m_188503_(3) < mc.f_91060_.f_109450_++) {
                        mc.f_91060_.f_109450_ = 0;
                        if (particlePos.m_123342_() > camPos.m_123342_() + 1 && mc.f_91073_.m_5452_(Heightmap.Types.MOTION_BLOCKING, camPos).m_123342_() > Mth.m_14143_((float)camPos.m_123342_())) {
                            mc.f_91073_.m_245747_(particlePos, SoundEvents.f_12542_, SoundSource.WEATHER, 0.1f, 0.5f, false);
                        } else {
                            mc.f_91073_.m_245747_(particlePos, SoundEvents.f_12541_, SoundSource.WEATHER, 0.2f, 1.0f, false);
                        }
                        yetToMakeASound = false;
                    }
                    if (highestRainyPos.m_123342_() <= mc.f_91073_.m_141937_() || highestRainyPos.m_123342_() > camPos.m_123342_() + 10 || highestRainyPos.m_123342_() < camPos.m_123342_() - 10) continue;
                    particlePos = highestRainyPos.m_7495_();
                    if (mc.f_91066_.m_231929_().m_231551_() == ParticleStatus.MINIMAL) continue block5;
                    double particleX = randomsource.m_188500_();
                    double particleZ = randomsource.m_188500_();
                    BlockState blockstate = mc.f_91073_.m_8055_(particlePos);
                    FluidState fluidstate = mc.f_91073_.m_6425_(particlePos);
                    VoxelShape voxelshape = blockstate.m_60812_((BlockGetter)mc.f_91073_, particlePos);
                    double voxelMax = voxelshape.m_83290_(Direction.Axis.Y, particleX, particleZ);
                    double fluidMax = fluidstate.m_76155_((BlockGetter)mc.f_91073_, particlePos);
                    double particleY = Math.max(voxelMax, fluidMax);
                    SimpleParticleType particleoptions = !fluidstate.m_205070_(FluidTags.f_13132_) && !blockstate.m_60713_(Blocks.f_50450_) && !CampfireBlock.m_51319_((BlockState)blockstate) ? ParticleTypes.f_123761_ : ParticleTypes.f_123762_;
                    mc.f_91073_.m_7106_((ParticleOptions)particleoptions, (double)particlePos.m_123341_() + particleX, (double)particlePos.m_123342_() + particleY, (double)particlePos.m_123343_() + particleZ, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @SubscribeEvent
    public static void renderCloudBlockPrecipitation(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_WEATHER && TFConfig.getClientCloudBlockPrecipitationDistance() > 0 && !RENDER_HELPER.isEmpty()) {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91073_ == null) {
                return;
            }
            float partialTick = minecraft.getPartialTick();
            LightTexture lightTexture = minecraft.f_91063_.m_109154_();
            int ticks = minecraft.f_91060_.getTicks();
            lightTexture.m_109896_();
            Vec3 vec3 = event.getCamera().m_90583_();
            double camX = vec3.m_7096_();
            double camY = vec3.m_7098_();
            double camZ = vec3.m_7094_();
            int floorX = Mth.m_14107_((double)camX);
            int floorY = Mth.m_14107_((double)camY);
            int floorZ = Mth.m_14107_((double)camZ);
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tesselator.m_85915_();
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)Minecraft.m_91085_());
            int renderDistance = Minecraft.m_91405_() ? 10 : 5;
            int tesselatorCheck = -1;
            float fullTick = (float)ticks + partialTick;
            RenderSystem.setShader(GameRenderer::m_172829_);
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            for (PrecipitationRenderHelper helper : RENDER_HELPER) {
                BlockPos pos = helper.cloudPos();
                int roofX = pos.m_123341_();
                int roofZ = pos.m_123343_();
                int botY = Math.max(helper.rainOnY(), floorY - renderDistance);
                int topY = Math.min(pos.m_123342_(), floorY + renderDistance);
                if (topY - botY <= 0) continue;
                int rainS = Mth.m_14045_((int)((roofZ - floorZ + 16) * 32 + roofX - floorX + 16), (int)0, (int)1023);
                double rainX = (double)TFWeatherRenderer.rainxs[rainS] * 0.5;
                double rainZ = (double)TFWeatherRenderer.rainzs[rainS] * 0.5;
                mutableBlockPos.m_122169_((double)roofX, camY, (double)roofZ);
                RandomSource random = RandomSource.m_216335_((long)((long)roofX * (long)roofX * 3121L + (long)roofX * 45238971L ^ (long)roofZ * (long)roofZ * 418711L + (long)roofZ * 13761L));
                if (helper.precipitation() == Biome.Precipitation.RAIN) {
                    if (tesselatorCheck != 0) {
                        if (tesselatorCheck >= 0) {
                            tesselator.m_85914_();
                        }
                        tesselatorCheck = 0;
                        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TFWeatherRenderer.RAIN_TEXTURES);
                        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
                    }
                    int offset = ticks + roofX * roofX * 3121 + roofX * 45238971 + roofZ * roofZ * 418711 + roofZ * 13761 & 0x1F;
                    float uvOffset = -((float)offset + partialTick) / 32.0f * (3.0f + random.m_188501_());
                    double xDiff = (double)roofX + 0.5 - camX;
                    double zDiff = (double)roofZ + 0.5 - camZ;
                    float distance = (float)Math.sqrt(xDiff * xDiff + zDiff * zDiff) / (float)renderDistance;
                    float alpha = ((1.0f - distance * distance) * 0.5f + 0.5f) * helper.precipitationLevel();
                    mutableBlockPos.m_122178_(roofX, Math.max(helper.rainOnY(), floorY), roofZ);
                    int lightColor = LevelRenderer.m_109541_((BlockAndTintGetter)minecraft.f_91073_, (BlockPos)mutableBlockPos);
                    bufferbuilder.m_5483_((double)roofX - camX - rainX + 0.5, (double)topY - camY, (double)roofZ - camZ - rainZ + 0.5).m_7421_(0.0f, (float)botY * 0.25f + uvOffset).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_85969_(lightColor).m_5752_();
                    bufferbuilder.m_5483_((double)roofX - camX + rainX + 0.5, (double)topY - camY, (double)roofZ - camZ + rainZ + 0.5).m_7421_(1.0f, (float)botY * 0.25f + uvOffset).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_85969_(lightColor).m_5752_();
                    bufferbuilder.m_5483_((double)roofX - camX + rainX + 0.5, (double)botY - camY, (double)roofZ - camZ + rainZ + 0.5).m_7421_(1.0f, (float)topY * 0.25f + uvOffset).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_85969_(lightColor).m_5752_();
                    bufferbuilder.m_5483_((double)roofX - camX - rainX + 0.5, (double)botY - camY, (double)roofZ - camZ - rainZ + 0.5).m_7421_(0.0f, (float)topY * 0.25f + uvOffset).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_85969_(lightColor).m_5752_();
                    continue;
                }
                if (helper.precipitation() != Biome.Precipitation.SNOW) continue;
                if (tesselatorCheck != 1) {
                    if (tesselatorCheck >= 0) {
                        tesselator.m_85914_();
                    }
                    tesselatorCheck = 1;
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)TFWeatherRenderer.SNOW_TEXTURES);
                    bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
                }
                float offset = -((float)(ticks & 0x1FF) + partialTick) / 512.0f;
                float uOffset = (float)(random.m_188500_() + (double)fullTick * 0.01 * (double)((float)random.m_188583_()));
                float vOffset = (float)(random.m_188500_() + (double)(fullTick * (float)random.m_188583_()) * 0.001);
                double xDiff = (double)roofX + 0.5 - camX;
                double zDiff = (double)roofZ + 0.5 - camZ;
                float distance = (float)Math.sqrt(xDiff * xDiff + zDiff * zDiff) / (float)renderDistance;
                float alpha = ((1.0f - distance * distance) * 0.3f + 0.5f) * helper.precipitationLevel();
                mutableBlockPos.m_122178_(roofX, Math.max(helper.rainOnY(), floorY), roofZ);
                int lightColor = LevelRenderer.m_109541_((BlockAndTintGetter)minecraft.f_91073_, (BlockPos)mutableBlockPos);
                int v = lightColor >> 16 & 0xFFFF;
                int u = lightColor & 0xFFFF;
                v = (v * 3 + 240) / 4;
                u = (u * 3 + 240) / 4;
                bufferbuilder.m_5483_((double)roofX - camX - rainX + 0.5, (double)topY - camY, (double)roofZ - camZ - rainZ + 0.5).m_7421_(0.0f + uOffset, (float)botY * 0.25f + offset + vOffset).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7120_(u, v).m_5752_();
                bufferbuilder.m_5483_((double)roofX - camX + rainX + 0.5, (double)topY - camY, (double)roofZ - camZ + rainZ + 0.5).m_7421_(1.0f + uOffset, (float)botY * 0.25f + offset + vOffset).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7120_(u, v).m_5752_();
                bufferbuilder.m_5483_((double)roofX - camX + rainX + 0.5, (double)botY - camY, (double)roofZ - camZ + rainZ + 0.5).m_7421_(1.0f + uOffset, (float)topY * 0.25f + offset + vOffset).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7120_(u, v).m_5752_();
                bufferbuilder.m_5483_((double)roofX - camX - rainX + 0.5, (double)botY - camY, (double)roofZ - camZ - rainZ + 0.5).m_7421_(0.0f + uOffset, (float)topY * 0.25f + offset + vOffset).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7120_(u, v).m_5752_();
            }
            if (tesselatorCheck >= 0) {
                tesselator.m_85914_();
            }
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            lightTexture.m_109891_();
        }
    }

    record PrecipitationRenderHelper(BlockPos cloudPos, Biome.Precipitation precipitation, float precipitationLevel, int rainOnY) {
    }
}

