/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.Nullable;
import twilightforest.init.TFSounds;

public class WroughtIronFenceBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final EnumProperty<PostState> POST = EnumProperty.m_61587_((String)"post", PostState.class);
    public static final EnumProperty<FenceSide> EAST_FENCE = EnumProperty.m_61587_((String)"east_fence", FenceSide.class);
    public static final EnumProperty<FenceSide> NORTH_FENCE = EnumProperty.m_61587_((String)"north_fence", FenceSide.class);
    public static final EnumProperty<FenceSide> SOUTH_FENCE = EnumProperty.m_61587_((String)"south_fence", FenceSide.class);
    public static final EnumProperty<FenceSide> WEST_FENCE = EnumProperty.m_61587_((String)"west_fence", FenceSide.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape POST_SHAPE = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape NORTH_SHAPE = Block.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)8.0);
    private static final VoxelShape SOUTH_SHAPE = Block.m_49796_((double)7.0, (double)0.0, (double)8.0, (double)9.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_SHAPE = Block.m_49796_((double)8.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
    private static final VoxelShape WEST_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)8.0, (double)16.0, (double)9.0);

    public WroughtIronFenceBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(POST, (Comparable)((Object)PostState.POST))).m_61124_(EAST_FENCE, (Comparable)((Object)FenceSide.NONE))).m_61124_(NORTH_FENCE, (Comparable)((Object)FenceSide.NONE))).m_61124_(SOUTH_FENCE, (Comparable)((Object)FenceSide.NONE))).m_61124_(WEST_FENCE, (Comparable)((Object)FenceSide.NONE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        VoxelShape finalShape = Shapes.m_83040_();
        if (state.m_61143_(POST) != PostState.NONE) {
            finalShape = POST_SHAPE;
        }
        if (state.m_61143_(NORTH_FENCE) != FenceSide.NONE) {
            finalShape = Shapes.m_83110_((VoxelShape)finalShape, (VoxelShape)NORTH_SHAPE);
        }
        if (state.m_61143_(SOUTH_FENCE) != FenceSide.NONE) {
            finalShape = Shapes.m_83110_((VoxelShape)finalShape, (VoxelShape)SOUTH_SHAPE);
        }
        if (state.m_61143_(WEST_FENCE) != FenceSide.NONE) {
            finalShape = Shapes.m_83110_((VoxelShape)finalShape, (VoxelShape)WEST_SHAPE);
        }
        if (state.m_61143_(EAST_FENCE) != FenceSide.NONE) {
            finalShape = Shapes.m_83110_((VoxelShape)finalShape, (VoxelShape)EAST_SHAPE);
        }
        if (finalShape.m_83281_()) {
            finalShape = Shapes.m_83144_();
        }
        return finalShape;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter getter, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"block.twilightforest.wrought_iron_fence.cap").m_130940_(ChatFormatting.GRAY));
    }

    @Deprecated
    public boolean m_7357_(BlockState state, BlockGetter getter, BlockPos pos, PathComputationType type) {
        return false;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState north = level.m_8055_(pos.m_122012_());
        BlockState east = level.m_8055_(pos.m_122029_());
        BlockState south = level.m_8055_(pos.m_122019_());
        BlockState west = level.m_8055_(pos.m_122024_());
        BlockState above = level.m_8055_(pos.m_7494_());
        boolean northFace = this.connectsTo(north, north.m_60783_((BlockGetter)level, pos.m_122012_(), Direction.SOUTH));
        boolean eastFace = this.connectsTo(east, east.m_60783_((BlockGetter)level, pos.m_122029_(), Direction.WEST));
        boolean southFace = this.connectsTo(south, south.m_60783_((BlockGetter)level, pos.m_122019_(), Direction.NORTH));
        boolean westFace = this.connectsTo(west, west.m_60783_((BlockGetter)level, pos.m_122024_(), Direction.EAST));
        FluidState fluid = context.m_43725_().m_6425_(context.m_8083_());
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.m_76152_() == Fluids.f_76193_));
        return this.fenceShape((LevelReader)level, state, pos.m_7494_(), above, northFace, eastFace, southFace, westFace);
    }

    private boolean connectsTo(BlockState state, boolean solid) {
        return state.m_60713_((Block)this) || !WroughtIronFenceBlock.m_152463_((BlockState)state) && solid;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if ((player.m_21120_(hand).m_204117_(Tags.Items.INGOTS_IRON) || player.m_21120_(hand).m_204117_(Tags.Items.NUGGETS_IRON)) && state.m_61143_(POST) != PostState.CAPPED && level.m_8055_(pos.m_7494_()).m_60795_()) {
            level.m_7731_(pos, (BlockState)state.m_61124_(POST, (Comparable)((Object)PostState.CAPPED)), 3);
            level.m_5594_(null, pos, (SoundEvent)TFSounds.WROUGHT_IRON_FENCE_EXTENDED.get(), SoundSource.BLOCKS, 0.35f, level.m_213780_().m_188501_() * 0.1f + 0.75f);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, hand, result);
    }

    @Deprecated
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighbor, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return direction == Direction.UP ? this.updateTop((LevelReader)level, state, neighborPos, neighbor) : this.updateSide((LevelReader)level, pos, state, neighborPos, neighbor, direction);
    }

    private BlockState updateSide(LevelReader level, BlockPos firstPos, BlockState firstState, BlockPos secondPos, BlockState secondState, Direction direction) {
        Direction opposite = direction.m_122424_();
        boolean north = direction == Direction.NORTH ? this.connectsTo(secondState, secondState.m_60783_((BlockGetter)level, secondPos, opposite)) : WroughtIronFenceBlock.isConnected(firstState, NORTH_FENCE);
        boolean east = direction == Direction.EAST ? this.connectsTo(secondState, secondState.m_60783_((BlockGetter)level, secondPos, opposite)) : WroughtIronFenceBlock.isConnected(firstState, EAST_FENCE);
        boolean south = direction == Direction.SOUTH ? this.connectsTo(secondState, secondState.m_60783_((BlockGetter)level, secondPos, opposite)) : WroughtIronFenceBlock.isConnected(firstState, SOUTH_FENCE);
        boolean west = direction == Direction.WEST ? this.connectsTo(secondState, secondState.m_60783_((BlockGetter)level, secondPos, opposite)) : WroughtIronFenceBlock.isConnected(firstState, WEST_FENCE);
        BlockPos above = firstPos.m_7494_();
        return this.fenceShape(level, firstState, above, level.m_8055_(above), north, east, south, west);
    }

    private BlockState updateTop(LevelReader level, BlockState state, BlockPos pos, BlockState facing) {
        boolean north = WroughtIronFenceBlock.isConnected(state, NORTH_FENCE);
        boolean east = WroughtIronFenceBlock.isConnected(state, EAST_FENCE);
        boolean south = WroughtIronFenceBlock.isConnected(state, SOUTH_FENCE);
        boolean west = WroughtIronFenceBlock.isConnected(state, WEST_FENCE);
        return this.fenceShape(level, state, pos, facing, north, east, south, west);
    }

    private static boolean isConnected(BlockState state, Property<FenceSide> side) {
        return state.m_61143_(side) != FenceSide.NONE;
    }

    private BlockState fenceShape(LevelReader level, BlockState state, BlockPos pos, BlockState neighbor, boolean north, boolean east, boolean south, boolean west) {
        BlockState above = level.m_8055_(pos);
        BlockState below = level.m_8055_(pos.m_6625_(2));
        BlockState blockstate = this.updateSides(state, above, below, north, east, south, west);
        return (BlockState)blockstate.m_61124_(POST, (Comparable)((Object)this.makePost(blockstate, neighbor, above.m_60795_())));
    }

    private PostState makePost(BlockState state, BlockState neighbor, boolean freeTop) {
        boolean west;
        boolean flag;
        boolean bl = flag = neighbor.m_60713_((Block)this) && neighbor.m_61143_(POST) != PostState.NONE;
        if (state.m_61143_(POST) == PostState.CAPPED && freeTop) {
            return PostState.CAPPED;
        }
        if (flag) {
            return PostState.POST;
        }
        FenceSide nSide = (FenceSide)((Object)state.m_61143_(NORTH_FENCE));
        FenceSide sSide = (FenceSide)((Object)state.m_61143_(SOUTH_FENCE));
        FenceSide eSide = (FenceSide)((Object)state.m_61143_(EAST_FENCE));
        FenceSide wSide = (FenceSide)((Object)state.m_61143_(WEST_FENCE));
        boolean north = nSide == FenceSide.NONE;
        boolean south = sSide == FenceSide.NONE;
        boolean east = eSide == FenceSide.NONE;
        boolean bl2 = west = wSide == FenceSide.NONE;
        if (north && south && east && west || north != south || east != west) {
            return PostState.POST;
        }
        return PostState.NONE;
    }

    private BlockState updateSides(BlockState state, BlockState above, BlockState below, boolean north, boolean east, boolean south, boolean west) {
        return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH_FENCE, (Comparable)((Object)this.makeFenceState(north, NORTH_FENCE, above, below)))).m_61124_(EAST_FENCE, (Comparable)((Object)this.makeFenceState(east, EAST_FENCE, above, below)))).m_61124_(SOUTH_FENCE, (Comparable)((Object)this.makeFenceState(south, SOUTH_FENCE, above, below)))).m_61124_(WEST_FENCE, (Comparable)((Object)this.makeFenceState(west, WEST_FENCE, above, below)));
    }

    private FenceSide makeFenceState(boolean connect, EnumProperty<FenceSide> property, BlockState above, BlockState below) {
        boolean flagA = false;
        boolean flagB = false;
        if (above.m_60713_((Block)this) && above.m_61143_(property) != FenceSide.NONE) {
            flagA = true;
        }
        if (below.m_60713_((Block)this) && below.m_61143_(property) != FenceSide.NONE) {
            flagB = true;
        }
        if (connect) {
            if (flagA && flagB) {
                return FenceSide.MIDDLE;
            }
            if (!flagA && flagB) {
                return FenceSide.TOP;
            }
            if (flagA && !flagB) {
                return FenceSide.BOTTOM;
            }
            return FenceSide.FULL;
        }
        return FenceSide.NONE;
    }

    @Deprecated
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7420_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) == false;
    }

    @Deprecated
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return switch (rotation) {
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH_FENCE, (Comparable)((Object)((FenceSide)((Object)state.m_61143_(SOUTH_FENCE)))))).m_61124_(EAST_FENCE, (Comparable)((Object)((FenceSide)((Object)state.m_61143_(WEST_FENCE)))))).m_61124_(SOUTH_FENCE, (Comparable)((Object)((FenceSide)((Object)state.m_61143_(NORTH_FENCE)))))).m_61124_(WEST_FENCE, (Comparable)((Object)((FenceSide)((Object)state.m_61143_(WEST_FENCE)))));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH_FENCE, (Comparable)((Object)((FenceSide)((Object)state.m_61143_(EAST_FENCE)))))).m_61124_(EAST_FENCE, (Comparable)((Object)((FenceSide)((Object)state.m_61143_(SOUTH_FENCE)))))).m_61124_(SOUTH_FENCE, (Comparable)((Object)((FenceSide)((Object)state.m_61143_(WEST_FENCE)))))).m_61124_(WEST_FENCE, (Comparable)((Object)((FenceSide)((Object)state.m_61143_(NORTH_FENCE)))));
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH_FENCE, (Comparable)((Object)((FenceSide)((Object)state.m_61143_(WEST_FENCE)))))).m_61124_(EAST_FENCE, (Comparable)((Object)((FenceSide)((Object)state.m_61143_(NORTH_FENCE)))))).m_61124_(SOUTH_FENCE, (Comparable)((Object)((FenceSide)((Object)state.m_61143_(EAST_FENCE)))))).m_61124_(WEST_FENCE, (Comparable)((Object)((FenceSide)((Object)state.m_61143_(SOUTH_FENCE)))));
            default -> state;
        };
    }

    @Deprecated
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return switch (mirror) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)state.m_61124_(NORTH_FENCE, (Comparable)((Object)((FenceSide)((Object)state.m_61143_(SOUTH_FENCE)))))).m_61124_(SOUTH_FENCE, (Comparable)((Object)((FenceSide)((Object)state.m_61143_(NORTH_FENCE)))));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)state.m_61124_(EAST_FENCE, (Comparable)((Object)((FenceSide)((Object)state.m_61143_(WEST_FENCE)))))).m_61124_(WEST_FENCE, (Comparable)((Object)((FenceSide)((Object)state.m_61143_(WEST_FENCE)))));
            default -> super.m_6943_(state, mirror);
        };
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POST, NORTH_FENCE, EAST_FENCE, WEST_FENCE, SOUTH_FENCE, WATERLOGGED});
    }

    public static enum PostState implements StringRepresentable
    {
        NONE,
        POST,
        CAPPED;


        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static enum FenceSide implements StringRepresentable
    {
        NONE,
        MIDDLE,
        BOTTOM,
        TOP,
        FULL;


        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

