/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.biome.Biome;
import twilightforest.init.TFBiomes;
import twilightforest.world.components.BiomeGrassColors;

public final class FoliageColorHandler {
    private static final Map<Biome, Handler> HANDLES = new WeakHashMap<Biome, Handler>();

    public static int get(int o, Biome biome, double x, double z) {
        Handler handler = HANDLES.get(biome);
        if (handler == null) {
            handler = Handler.REGISTRY.getOrDefault(Minecraft.m_91087_().f_91073_ == null ? null : Minecraft.m_91087_().f_91073_.m_9598_().m_175515_(Registries.f_256952_).m_7854_((Object)biome).orElse(null), Handler.DEFAULT);
            HANDLES.put(biome, handler);
        }
        return handler.apply(o, x, z);
    }

    @FunctionalInterface
    private static interface Handler {
        public static final Map<ResourceKey<Biome>, Handler> REGISTRY = new HashMap<ResourceKey<Biome>, Handler>(){
            {
                this.put(TFBiomes.SPOOKY_FOREST, (o, x, z) -> {
                    double noise = (Biome.f_47435_.m_75449_(x * 0.0225, z * 0.0225, false) + 1.0) / 2.0;
                    return BiomeGrassColors.blendColors(0xFF0101, 4849409, noise > 0.6 ? noise * 0.2 : noise);
                });
                this.put(TFBiomes.ENCHANTED_FOREST, (o, x, z) -> (o & 0xFFFF00) + BiomeGrassColors.getEnchantedColor((int)x, (int)z));
                this.put(TFBiomes.DARK_FOREST_CENTER, (o, x, z) -> {
                    double noise = (Biome.f_47435_.m_75449_(x * 0.0225, z * 0.0225, false) + 1.0) / 2.0;
                    return noise < -0.1 ? 16351774 : 15289876;
                });
                this.put(TFBiomes.DARK_FOREST, (o, x, z) -> ((FoliageColor.m_46107_((double)0.7f, (double)0.8f) & 0xFEFEFE) + 1969742) / 2);
                this.put(TFBiomes.SWAMP, (o, x, z) -> ((FoliageColor.m_46107_((double)0.8f, (double)0.9f) & 0xFEFEFE) + 0x4E0E4E) / 2);
            }
        };
        public static final Handler DEFAULT = (o, x, z) -> o;

        public int apply(int var1, double var2, double var4);
    }
}

