/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.mixin.lightsource;

import dev.lambdaurora.lambdynlights.DynamicLightSource;
import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.api.DynamicLightHandlers;
import dev.lambdaurora.lambdynlights.config.DynamicLightsConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements DynamicLightSource {
    @Unique
    protected int lambdynlights$luminance;

    public LivingEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Override
    public void tdv$dynamicLightTick() {
        int luminance;
        if (!((Boolean)DynamicLightsConfig.TileEntityLighting.get()).booleanValue() || !DynamicLightHandlers.canLightUp(this)) {
            this.lambdynlights$luminance = 0;
            return;
        }
        if (this.m_6060_() || this.m_142038_()) {
            this.lambdynlights$luminance = 15;
        } else {
            luminance = 0;
            BlockPos eyePos = BlockPos.m_274561_((double)this.m_20185_(), (double)this.m_20188_(), (double)this.m_20189_());
            boolean submergedInFluid = !this.m_9236_().m_6425_(eyePos).m_76178_();
            for (ItemStack equipped : this.m_20158_()) {
                if (equipped.m_41619_()) continue;
                luminance = Math.max(luminance, LambDynLights.getLuminanceFromItemStack(equipped, submergedInFluid));
            }
            this.lambdynlights$luminance = luminance;
        }
        luminance = DynamicLightHandlers.getLuminanceFrom(this);
        if (luminance > this.lambdynlights$luminance) {
            this.lambdynlights$luminance = luminance;
        }
    }

    @Override
    public int tdv$getLuminance() {
        return this.lambdynlights$luminance;
    }
}

