/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.util;

import dev.architectury.platform.Platform;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import net.sweenus.simplyswords.SimplySwordsExpectPlatform;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.entity.BattleStandardDarkEntity;
import net.sweenus.simplyswords.entity.BattleStandardEntity;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;

public class HelperMethods {
    public static Entity getTargetedEntity(Entity user, int range) {
        AABB searchBox;
        Vec3 userView;
        Vec3 rayCastEnd;
        Vec3 rayCastOrigin = user.m_146892_();
        EntityHitResult hitResult = ProjectileUtil.m_37287_((Entity)user, (Vec3)rayCastOrigin, (Vec3)(rayCastEnd = rayCastOrigin.m_82549_(userView = user.m_20252_(1.0f).m_82541_().m_82490_((double)range))), (AABB)(searchBox = user.m_20191_().m_82377_((double)range, (double)range, (double)range)), target -> !target.m_5833_() && target.m_6087_() && target instanceof LivingEntity, (double)(range * range));
        if (hitResult != null) {
            return hitResult.m_82443_();
        }
        return null;
    }

    public static boolean isWalking(Entity entity) {
        Player player;
        return entity instanceof Player && !(player = (Player)entity).m_21224_() && (player.m_6069_() || player.m_20184_().m_165924_() > 0.1);
    }

    public static Style getStyle(String styleType) {
        int rgbCommon = 0xFFFFFF;
        int rgbRunic = 10314442;
        int rgbUnique = 14854196;
        int rgbLegendary = 14836276;
        int rgbAbility = 14854196;
        int rgbRightClick = 2145641;
        int rgbText = 0xE0E0E0;
        Style COMMON = Style.f_131099_.m_131148_(TextColor.m_131266_((int)rgbCommon));
        Style UNIQUE = Style.f_131099_.m_131148_(TextColor.m_131266_((int)rgbUnique));
        Style LEGENDARY = Style.f_131099_.m_131148_(TextColor.m_131266_((int)rgbLegendary));
        Style ABILITY = Style.f_131099_.m_131148_(TextColor.m_131266_((int)rgbAbility));
        Style RIGHTCLICK = Style.f_131099_.m_131148_(TextColor.m_131266_((int)rgbRightClick));
        Style RUNIC = Style.f_131099_.m_131148_(TextColor.m_131266_((int)rgbRunic));
        Style TEXT = Style.f_131099_.m_131148_(TextColor.m_131266_((int)rgbText));
        return switch (styleType) {
            case "unique" -> UNIQUE;
            case "legendary" -> LEGENDARY;
            case "ability" -> ABILITY;
            case "rightclick" -> RIGHTCLICK;
            case "runic" -> RUNIC;
            case "text" -> TEXT;
            default -> COMMON;
        };
    }

    public static boolean checkFriendlyFire(LivingEntity target, LivingEntity attacker) {
        TamableAnimal tameableEntity;
        if (!HelperMethods.checkEntityBlacklist(target, attacker)) {
            return false;
        }
        Team playerTeam = attacker.m_5647_();
        Team entityTeam = target.m_5647_();
        if (playerTeam != null && entityTeam != null && target.m_7307_((Entity)attacker)) {
            return false;
        }
        if (target instanceof Player) {
            Player playerAttacker;
            Player playerTarget = (Player)target;
            if (playerTarget == attacker) {
                return false;
            }
            return !(attacker instanceof Player) || (playerAttacker = (Player)attacker).m_7099_(playerTarget);
        }
        if (target instanceof TamableAnimal && (tameableEntity = (TamableAnimal)target).m_269323_() != null) {
            return tameableEntity.m_269323_() != attacker;
        }
        return true;
    }

    public static boolean checkEntityBlacklist(LivingEntity target, LivingEntity player) {
        if (target == null || player == null) {
            return false;
        }
        return !(target instanceof ArmorStand) && !(target instanceof Villager) && !(target instanceof BattleStandardEntity) && !(target instanceof BattleStandardDarkEntity);
    }

    public static void spawnParticle(Level world, ParticleOptions particle, double xpos, double ypos, double zpos, double xvelocity, double yvelocity, double zvelocity) {
        if (world.f_46443_) {
            world.m_7106_(particle, xpos, ypos, zpos, xvelocity, yvelocity, zvelocity);
        } else if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            serverWorld.m_8767_(particle, xpos, ypos, zpos, 1, xvelocity, yvelocity, zvelocity, 0.1);
        }
    }

    public static void playHitSounds(LivingEntity attacker, LivingEntity target) {
        if (!attacker.m_9236_().m_5776_()) {
            ServerLevel world = (ServerLevel)attacker.m_9236_();
            boolean impactsounds_enabled = Config.getBoolean("enableWeaponImpactSounds", "General", ConfigDefaultValues.enableWeaponImpactSounds);
            float impactsounds_volume = Config.getFloat("weaponImpactSoundsVolume", "General", ConfigDefaultValues.weaponImpactSoundsVolume);
            if (impactsounds_enabled) {
                int choose_sound = (int)(Math.random() * 30.0);
                float choose_pitch = (float)Math.random() * 2.0f;
                if (choose_sound <= 10) {
                    world.m_6269_(null, (Entity)target, (SoundEvent)SoundRegistry.MAGIC_SWORD_ATTACK_WITH_BLOOD_01.get(), SoundSource.PLAYERS, impactsounds_volume, 1.1f + choose_pitch);
                } else if (choose_sound <= 20) {
                    world.m_6269_(null, (Entity)target, (SoundEvent)SoundRegistry.MAGIC_SWORD_ATTACK_WITH_BLOOD_02.get(), SoundSource.PLAYERS, impactsounds_volume, 1.1f + choose_pitch);
                } else if (choose_sound <= 30) {
                    world.m_6269_(null, (Entity)target, (SoundEvent)SoundRegistry.MAGIC_SWORD_ATTACK_WITH_BLOOD_03.get(), SoundSource.PLAYERS, impactsounds_volume, 1.1f + choose_pitch);
                } else if (choose_sound <= 40) {
                    world.m_6269_(null, (Entity)target, (SoundEvent)SoundRegistry.MAGIC_SWORD_ATTACK_WITH_BLOOD_04.get(), SoundSource.PLAYERS, impactsounds_volume, 1.1f + choose_pitch);
                }
            }
        }
    }

    public static boolean checkRunicBlacklist(String runicPower) {
        return switch (runicPower) {
            case "active_defence" -> Config.getBoolean("enableActiveDefence", "RunicEffects", ConfigDefaultValues.enableActiveDefence);
            case "float" -> Config.getBoolean("enableFloat", "RunicEffects", ConfigDefaultValues.enableFloat);
            case "greater_float" -> Config.getBoolean("enableGreaterFloat", "RunicEffects", ConfigDefaultValues.enableGreaterFloat);
            case "freeze" -> Config.getBoolean("enableFreeze", "RunicEffects", ConfigDefaultValues.enableFreeze);
            case "shielding" -> Config.getBoolean("enableShielding", "RunicEffects", ConfigDefaultValues.enableShielding);
            case "greater_shielding" -> Config.getBoolean("enableGreaterShielding", "RunicEffects", ConfigDefaultValues.enableGreaterShielding);
            case "slow" -> Config.getBoolean("enableSlow", "RunicEffects", ConfigDefaultValues.enableSlow);
            case "greater_slow" -> Config.getBoolean("enableGreaterSlow", "RunicEffects", ConfigDefaultValues.enableGreaterSlow);
            case "stoneskin" -> Config.getBoolean("enableStoneskin", "RunicEffects", ConfigDefaultValues.enableStoneskin);
            case "greater_stoneskin" -> Config.getBoolean("enableGreaterStoneskin", "RunicEffects", ConfigDefaultValues.enableGreaterStoneskin);
            case "swiftness" -> Config.getBoolean("enableSwiftness", "RunicEffects", ConfigDefaultValues.enableSwiftness);
            case "greater_swiftness" -> Config.getBoolean("enableGreaterSwiftness", "RunicEffects", ConfigDefaultValues.enableGreaterSwiftness);
            case "trailblaze" -> Config.getBoolean("enableTrailblaze", "RunicEffects", ConfigDefaultValues.enableTrailblaze);
            case "greater_trailblaze" -> Config.getBoolean("enableGreaterTrailblaze", "RunicEffects", ConfigDefaultValues.enableGreaterTrailblaze);
            case "weaken" -> Config.getBoolean("enableWeaken", "RunicEffects", ConfigDefaultValues.enableWeaken);
            case "greater_weaken" -> Config.getBoolean("enableGreaterWeaken", "RunicEffects", ConfigDefaultValues.enableGreaterWeaken);
            case "zephyr" -> Config.getBoolean("enableZephyr", "RunicEffects", ConfigDefaultValues.enableZephyr);
            case "greater_zephyr" -> Config.getBoolean("enableGreaterZephyr", "RunicEffects", ConfigDefaultValues.enableGreaterZephyr);
            case "frost_ward" -> Config.getBoolean("enableFrostWard", "RunicEffects", ConfigDefaultValues.enableFrostWard);
            case "wildfire" -> Config.getBoolean("enableWildfire", "RunicEffects", ConfigDefaultValues.enableWildfire);
            case "unstable" -> Config.getBoolean("enableUnstable", "RunicEffects", ConfigDefaultValues.enableUnstable);
            case "momentum" -> Config.getBoolean("enableMomentum", "RunicEffects", ConfigDefaultValues.enableMomentum);
            case "greater_momentum" -> Config.getBoolean("enableGreaterMomentum", "RunicEffects", ConfigDefaultValues.enableGreaterMomentum);
            case "imbued" -> Config.getBoolean("enableImbued", "RunicEffects", ConfigDefaultValues.enableImbued);
            case "greater_imbued" -> Config.getBoolean("enableGreaterImbued", "RunicEffects", ConfigDefaultValues.enableGreaterImbued);
            case "pincushion" -> Config.getBoolean("enablePincushion", "RunicEffects", ConfigDefaultValues.enablePincushion);
            case "greater_pincushion" -> Config.getBoolean("enableGreaterPincushion", "RunicEffects", ConfigDefaultValues.enableGreaterPincushion);
            case "ward" -> Config.getBoolean("enableWard", "RunicEffects", ConfigDefaultValues.enableWard);
            case "immolation" -> Config.getBoolean("enableImmolate", "RunicEffects", ConfigDefaultValues.enableImmolate);
            default -> false;
        };
    }

    public static boolean checkNetherBlacklist(String netherPower) {
        return switch (netherPower) {
            case "echo" -> Config.getBoolean("enableEcho", "GemEffects", ConfigDefaultValues.enableEcho);
            case "berserk" -> Config.getBoolean("enableBerserk", "GemEffects", ConfigDefaultValues.enableBerserk);
            case "radiance" -> Config.getBoolean("enableRadiance", "GemEffects", ConfigDefaultValues.enableRadiance);
            case "onslaught" -> Config.getBoolean("enableOnslaught", "GemEffects", ConfigDefaultValues.enableOnslaught);
            case "nullification" -> Config.getBoolean("enableNullification", "GemEffects", ConfigDefaultValues.enableNullification);
            case "precise" -> Config.getBoolean("enablePrecise", "GemEffects", ConfigDefaultValues.enablePrecise);
            case "mighty" -> Config.getBoolean("enableMighty", "GemEffects", ConfigDefaultValues.enableMighty);
            case "stealthy" -> Config.getBoolean("enableStealthy", "GemEffects", ConfigDefaultValues.enableStealthy);
            case "renewed" -> Config.getBoolean("enableRenewed", "GemEffects", ConfigDefaultValues.enableRenewed);
            case "accelerant" -> Config.getBoolean("enableAccelerant", "GemEffects", ConfigDefaultValues.enableAccelerant);
            case "leaping" -> Config.getBoolean("enableLeaping", "GemEffects", ConfigDefaultValues.enableLeaping);
            case "spellshield" -> Config.getBoolean("enableSpellshield", "GemEffects", ConfigDefaultValues.enableSpellshield);
            case "spellforged" -> Config.getBoolean("enableSpellforged", "GemEffects", ConfigDefaultValues.enableSpellforged);
            case "soulshock" -> Config.getBoolean("enableSoulshock", "GemEffects", ConfigDefaultValues.enableSoulshock);
            case "spell_standard" -> Config.getBoolean("enableSpellStandard", "GemEffects", ConfigDefaultValues.enableSpellStandard);
            case "war_standard" -> Config.getBoolean("enableWarStandard", "GemEffects", ConfigDefaultValues.enableWarStandard);
            case "deception" -> Config.getBoolean("enableDeception", "GemEffects", ConfigDefaultValues.enableDeception);
            default -> false;
        };
    }

    public static String chooseRunicPower() {
        Random choose;
        int randomIndex;
        String runicSelection;
        List<String> runicList = Arrays.asList("active_defence", "float", "greater_float", "freeze", "shielding", "greater_shielding", "slow", "greater_slow", "stoneskin", "greater_stoneskin", "swiftness", "greater_swiftness", "trailblaze", "greater_trailblaze", "weaken", "greater_weaken", "zephyr", "greater_zephyr", "frost_ward", "wildfire", "unstable", "momentum", "greater_momentum", "imbued", "greater_imbued", "pincushion", "greater_pincushion", "ward", "immolation");
        while (!HelperMethods.checkRunicBlacklist(runicSelection = runicList.get(randomIndex = (choose = new Random()).nextInt(runicList.size())))) {
        }
        return runicSelection;
    }

    public static String chooseRunefusedPower() {
        Random choose;
        int randomIndex;
        String runicSelection;
        List<String> runicList = Arrays.asList("active_defence", "float", "greater_float", "freeze", "shielding", "greater_shielding", "slow", "greater_slow", "stoneskin", "greater_stoneskin", "swiftness", "greater_swiftness", "trailblaze", "greater_trailblaze", "weaken", "greater_weaken", "zephyr", "greater_zephyr", "frost_ward", "wildfire", "unstable", "imbued", "greater_imbued", "pincushion", "greater_pincushion");
        while (!HelperMethods.checkRunicBlacklist(runicSelection = runicList.get(randomIndex = (choose = new Random()).nextInt(runicList.size())))) {
        }
        return runicSelection;
    }

    public static String chooseNetherfusedPower() {
        Random choose;
        int randomIndex;
        String netherSelection;
        List<String> netherList = Platform.isModLoaded((String)"simplyskills") ? Arrays.asList("echo", "berserk", "radiance", "onslaught", "nullification", "precise", "mighty", "stealthy", "renewed", "accelerant", "leaping", "spellshield", "spellforged", "soulshock", "spell_standard", "war_standard", "deception") : Arrays.asList("echo", "berserk", "radiance", "onslaught", "nullification");
        while (!HelperMethods.checkNetherBlacklist(netherSelection = netherList.get(randomIndex = (choose = new Random()).nextInt(netherList.size())))) {
        }
        return netherSelection;
    }

    public static boolean isUniqueTwohanded(ItemStack stack) {
        return stack.m_150930_((Item)ItemsRegistry.SOULPYRE.get()) || stack.m_150930_((Item)ItemsRegistry.SOULKEEPER.get()) || stack.m_150930_((Item)ItemsRegistry.TWISTED_BLADE.get()) || stack.m_150930_((Item)ItemsRegistry.HEARTHFLAME.get()) || stack.m_150930_((Item)ItemsRegistry.SOULRENDER.get()) || stack.m_150930_((Item)ItemsRegistry.SLUMBERING_LICHBLADE.get()) || stack.m_150930_((Item)ItemsRegistry.WAKING_LICHBLADE.get()) || stack.m_150930_((Item)ItemsRegistry.AWAKENED_LICHBLADE.get()) || stack.m_150930_((Item)ItemsRegistry.BRIMSTONE_CLAYMORE.get()) || stack.m_150930_((Item)ItemsRegistry.ICEWHISPER.get()) || stack.m_150930_((Item)ItemsRegistry.ARCANETHYST.get()) || stack.m_150930_((Item)ItemsRegistry.THUNDERBRAND.get()) || stack.m_150930_((Item)ItemsRegistry.WHISPERWIND.get()) || stack.m_150930_((Item)ItemsRegistry.WATCHER_CLAYMORE.get());
    }

    public static AABB createBox(Entity entity, int radius) {
        return new AABB(entity.m_20185_() + (double)radius, entity.m_20186_() + (double)((float)radius / 3.0f), entity.m_20189_() + (double)radius, entity.m_20185_() - (double)radius, entity.m_20186_() - (double)((float)radius / 3.0f), entity.m_20189_() - (double)radius);
    }

    public static Vec3 getPositionLookingAt(Player player, int range) {
        HitResult result = player.m_19907_((double)range, 0.0f, false);
        if (result.m_6662_() != HitResult.Type.BLOCK) {
            return null;
        }
        BlockHitResult blockResult = (BlockHitResult)result;
        return blockResult.m_82450_();
    }

    public static void incrementStatusEffect(LivingEntity livingEntity, MobEffect statusEffect, int duration, int amplifier, int amplifierMax) {
        if (livingEntity.m_21023_(statusEffect)) {
            int currentDuration = livingEntity.m_21124_(statusEffect).m_19557_();
            int currentAmplifier = livingEntity.m_21124_(statusEffect).m_19564_();
            if (currentAmplifier >= amplifierMax) {
                livingEntity.m_7292_(new MobEffectInstance(statusEffect, Math.max(currentDuration, duration), currentAmplifier));
                return;
            }
            livingEntity.m_7292_(new MobEffectInstance(statusEffect, Math.max(currentDuration, duration), Math.min(amplifierMax, currentAmplifier + amplifier)));
        }
        livingEntity.m_7292_(new MobEffectInstance(statusEffect, duration));
    }

    public static void decrementStatusEffect(LivingEntity livingEntity, MobEffect statusEffect) {
        if (livingEntity.m_21023_(statusEffect)) {
            int currentAmplifier = livingEntity.m_21124_(statusEffect).m_19564_();
            int currentDuration = livingEntity.m_21124_(statusEffect).m_19557_();
            if (currentAmplifier < 1) {
                livingEntity.m_21195_(statusEffect);
                return;
            }
            livingEntity.m_21195_(statusEffect);
            livingEntity.m_7292_(new MobEffectInstance(statusEffect, currentDuration, currentAmplifier - 1));
        }
    }

    public static void createFootfalls(Entity entity, ItemStack stack, Level world, int stepMod, SimpleParticleType particle, SimpleParticleType sprintParticle, SimpleParticleType passiveParticle, boolean passiveParticles) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (Config.getBoolean("enableWeaponFootfalls", "General", ConfigDefaultValues.enableWeaponFootfalls) && player.m_6844_(EquipmentSlot.MAINHAND) == stack) {
                if (HelperMethods.isWalking((Entity)player) && !player.m_6069_() && player.m_20096_()) {
                    if (stepMod == 6) {
                        if (player.m_20142_()) {
                            world.m_7106_((ParticleOptions)sprintParticle, player.m_20185_() + player.m_204034_(stack.m_41720_()).m_7096_(), player.m_20186_() + player.m_204034_(stack.m_41720_()).m_7098_() + 0.2, player.m_20189_() + player.m_204034_(stack.m_41720_()).m_7094_(), 0.0, 0.0, 0.0);
                        } else {
                            world.m_7106_((ParticleOptions)particle, player.m_20185_() + player.m_204034_(stack.m_41720_()).m_7096_(), player.m_20186_() + player.m_204034_(stack.m_41720_()).m_7098_() + 0.2, player.m_20189_() + player.m_204034_(stack.m_41720_()).m_7094_(), 0.0, 0.0, 0.0);
                        }
                    } else if (stepMod == 3) {
                        if (player.m_20142_()) {
                            world.m_7106_((ParticleOptions)sprintParticle, player.m_20185_() - player.m_204034_(stack.m_41720_()).m_7096_(), player.m_20186_() + player.m_204034_(stack.m_41720_()).m_7098_() + 0.2, player.m_20189_() - player.m_204034_(stack.m_41720_()).m_7094_(), 0.0, 0.0, 0.0);
                        } else {
                            world.m_7106_((ParticleOptions)particle, player.m_20185_() - player.m_204034_(stack.m_41720_()).m_7096_(), player.m_20186_() + player.m_204034_(stack.m_41720_()).m_7098_() + 0.2, player.m_20189_() - player.m_204034_(stack.m_41720_()).m_7094_(), 0.0, 0.0, 0.0);
                        }
                    }
                }
                if (passiveParticles && Config.getBoolean("enablePassiveParticles", "General", ConfigDefaultValues.enablePassiveParticles)) {
                    float randomy = (float)Math.random();
                    if (stepMod == 1) {
                        world.m_7106_((ParticleOptions)passiveParticle, player.m_20185_() - player.m_204034_(stack.m_41720_()).m_7096_(), player.m_20186_() + player.m_204034_(stack.m_41720_()).m_7098_() + 0.4 + (double)randomy, player.m_20189_() - player.m_204034_(stack.m_41720_()).m_7094_(), 0.0, 0.0, 0.0);
                        world.m_7106_((ParticleOptions)passiveParticle, player.m_20185_() - player.m_204034_(stack.m_41720_()).m_7096_() + 0.1, player.m_20186_() + player.m_204034_(stack.m_41720_()).m_7098_() + (double)randomy, player.m_20189_() - player.m_204034_(stack.m_41720_()).m_7094_() - 0.1, 0.0, 0.0, 0.0);
                    } else if (stepMod == 4) {
                        world.m_7106_((ParticleOptions)passiveParticle, player.m_20185_() + player.m_204034_(stack.m_41720_()).m_7096_(), player.m_20186_() + player.m_204034_(stack.m_41720_()).m_7098_() + 0.4 + (double)randomy, player.m_20189_() + player.m_204034_(stack.m_41720_()).m_7094_(), 0.0, 0.0, 0.0);
                        world.m_7106_((ParticleOptions)passiveParticle, player.m_20185_() + player.m_204034_(stack.m_41720_()).m_7096_() - 0.1, player.m_20186_() + player.m_204034_(stack.m_41720_()).m_7098_() + (double)randomy, player.m_20189_() + player.m_204034_(stack.m_41720_()).m_7094_() + 0.1, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
    }

    public static float commonSpellAttributeScaling(float damageModifier, Entity entity, String magicSchool) {
        if (Platform.isModLoaded((String)"spell_power") && Platform.isFabric() && entity instanceof Player) {
            Player player = (Player)entity;
            if (Config.getBoolean("compatEnableSpellPowerScaling", "General", ConfigDefaultValues.compatEnableSpellPowerScaling)) {
                return SimplySwordsExpectPlatform.getSpellPowerDamage(damageModifier, player, magicSchool);
            }
        }
        return 0.0f;
    }
}

