/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.util.HelperMethods;

public class BrambleSwordItem
extends UniqueSwordItem {
    private static int stepMod = 0;

    public BrambleSwordItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Override
    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.m_9236_().m_5776_()) {
            ServerLevel world = (ServerLevel)attacker.m_9236_();
            int fhitchance = (int)Config.getFloat("brambleChance", "UniqueEffects", ConfigDefaultValues.brambleChance);
            HelperMethods.playHitSounds(attacker, target);
            if (attacker.m_217043_().m_188503_(100) <= fhitchance) {
                int sradius = (int)Config.getFloat("brambleRadius", "UniqueEffects", ConfigDefaultValues.brambleRadius);
                int vradius = (int)(Config.getFloat("brambleRadius", "UniqueEffects", ConfigDefaultValues.brambleRadius) / 2.0f);
                double x = target.m_20185_();
                double y = target.m_20186_();
                double z = target.m_20189_();
                AABB box = new AABB(x + 10.0, y + 5.0, z + 10.0, x - 10.0, y - 5.0, z - 10.0);
                for (Entity entity : world.m_6249_((Entity)attacker, box, EntitySelector.f_20403_)) {
                    if (entity == null || !HelperMethods.checkFriendlyFire((LivingEntity)entity, attacker)) continue;
                    target = (LivingEntity)entity;
                    target.m_147207_(new MobEffectInstance(MobEffects.f_19614_, 300, 1), (Entity)attacker);
                    target.m_147207_(new MobEffectInstance(MobEffects.f_19597_, 150, 1), (Entity)attacker);
                }
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    @Override
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (stepMod > 0) {
            --stepMod;
        }
        if (stepMod <= 0) {
            stepMod = 7;
        }
        HelperMethods.createFootfalls(entity, stack, world, stepMod, ParticleTypes.f_175833_, ParticleTypes.f_175833_, ParticleTypes.f_123757_, true);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    @Override
    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style ABILITY = HelperMethods.getStyle("ability");
        Style TEXT = HelperMethods.getStyle("text");
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.bramblesworditem.tooltip1").m_6270_(ABILITY));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.bramblesworditem.tooltip2").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.bramblesworditem.tooltip3").m_6270_(TEXT));
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

