/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.sodiumextra.client;

import com.google.common.collect.EvictingQueue;
import java.util.Queue;
import java.util.stream.IntStream;
import me.flashyreese.mods.sodiumextra.mixin.gui.MinecraftClientAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT}, modid="rubidium_extra")
public class ClientTickHandler {
    private static int averageFps;
    private static int lowestFps;
    private static int highestFps;
    private static final Queue<Integer> fpsQueue;

    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        int currentFPS = MinecraftClientAccessor.getCurrentFPS();
        fpsQueue.add(currentFPS);
        int[] fpsArray = fpsQueue.stream().mapToInt(Integer::intValue).toArray();
        averageFps = (int)IntStream.of(fpsArray).average().orElse(0.0);
        lowestFps = IntStream.of(fpsArray).min().orElse(0);
        highestFps = IntStream.of(fpsArray).max().orElse(0);
    }

    public static int getAverageFps() {
        return averageFps;
    }

    public static int getLowestFps() {
        return lowestFps;
    }

    public static int getHighestFps() {
        return highestFps;
    }

    static {
        fpsQueue = EvictingQueue.create((int)200);
    }
}

