/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.blocks.entity;

import com.jesz.createdieselgenerators.blocks.HugeDieselEngineBlock;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.foundation.utility.Couple;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class PoweredEngineShaftBlockEntity
extends GeneratingKineticBlockEntity {
    float stressCapacity;
    float speed;
    int movementDirection = 0;
    int initialTicks;
    public Map<BlockPos, Couple<Float>> engines = new HashMap<BlockPos, Couple<Float>>();

    public PoweredEngineShaftBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public boolean isEngineForConnectorDisplay(BlockPos pos) {
        Direction.Axis axis = (Direction.Axis)this.m_58900_().m_61143_((Property)RotatedPillarKineticBlock.AXIS);
        for (Direction d : List.of(axis == Direction.Axis.Z ? Direction.UP : Direction.NORTH, axis == Direction.Axis.Z ? Direction.DOWN : Direction.SOUTH, axis == Direction.Axis.X ? Direction.UP : Direction.EAST, axis == Direction.Axis.X ? Direction.DOWN : Direction.WEST)) {
            BlockState st = this.m_58904_().m_8055_(this.m_58899_().m_5484_(d, 2));
            if (!(st.m_60734_() instanceof HugeDieselEngineBlock) || st.m_61143_((Property)HugeDieselEngineBlock.FACING) != d.m_122424_()) continue;
            return this.m_58899_().m_5484_(d, 2).equals((Object)pos);
        }
        return false;
    }

    public void update(BlockPos sourcePos, int direction, float stress, float speed) {
        if (this.engines.containsKey(sourcePos)) {
            this.engines.replace(sourcePos, (Couple<Float>)Couple.create((Object)Float.valueOf(stress), (Object)Float.valueOf(speed)));
        } else {
            this.engines.put(sourcePos, (Couple<Float>)Couple.create((Object)Float.valueOf(stress), (Object)Float.valueOf(speed)));
        }
        AtomicReference<Float> maxSpeed = new AtomicReference<Float>(Float.valueOf(0.0f));
        Map<BlockPos, Couple<Float>> map = Map.copyOf(this.engines);
        for (Couple<Float> s : map.values()) {
            if (!(((Float)s.getSecond()).floatValue() > maxSpeed.get().floatValue())) continue;
            maxSpeed.set((Float)s.getSecond());
        }
        this.speed = maxSpeed.get().floatValue();
        this.movementDirection = direction;
        this.updateGeneratedRotation();
    }

    public boolean canBePoweredBy(BlockPos globalPos) {
        return this.initialTicks == 0;
    }

    public void removeGenerator(BlockPos sourcePos) {
        this.engines.remove(sourcePos);
        if (this.engines.isEmpty()) {
            this.movementDirection = 0;
            this.speed = 0.0f;
            this.stressCapacity = 0.0f;
        }
        this.updateGeneratedRotation();
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("Direction", this.movementDirection);
        if (this.initialTicks > 0) {
            compound.m_128405_("Warmup", this.initialTicks);
        }
        ListTag engineList = new ListTag();
        Map<BlockPos, Couple<Float>> map = Map.copyOf(this.engines);
        map.forEach((p, s) -> {
            CompoundTag tag = new CompoundTag();
            tag.m_128350_("Capacity", ((Float)s.getFirst()).floatValue());
            tag.m_128350_("Speed", ((Float)s.getSecond()).floatValue());
            tag.m_128365_("Pos", (Tag)NbtUtils.m_129224_((BlockPos)p));
            engineList.add((Object)tag);
        });
        compound.m_128350_("GeneratedSpeed", this.speed);
        compound.m_128365_("Engines", (Tag)engineList);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.movementDirection = compound.m_128451_("Direction");
        this.initialTicks = compound.m_128451_("Warmup");
        ListTag engineList = compound.m_128437_("Engines", 10);
        HashMap<BlockPos, Couple<Float>> map = new HashMap<BlockPos, Couple<Float>>();
        for (int i = 0; i < engineList.size(); ++i) {
            map.put(NbtUtils.m_129239_((CompoundTag)engineList.m_128728_(i).m_128469_("Pos")), (Couple<Float>)Couple.create((Object)Float.valueOf(engineList.m_128728_(i).m_128457_("Capacity")), (Object)Float.valueOf(engineList.m_128728_(i).m_128457_("Speed"))));
        }
        this.engines.clear();
        this.engines = map;
        this.speed = compound.m_128457_("GeneratedSpeed");
    }

    public float getGeneratedSpeed() {
        return (float)this.movementDirection * this.speed;
    }

    public float calculateAddedStressCapacity() {
        if (this.movementDirection == 0) {
            return 0.0f;
        }
        AtomicReference<Float> stress = new AtomicReference<Float>(Float.valueOf(0.0f));
        Map<BlockPos, Couple<Float>> map = Map.copyOf(this.engines);
        map.forEach((b, s) -> stress.updateAndGet(f -> Float.valueOf(f.floatValue() + ((Float)s.getFirst()).floatValue() / ((Float)s.getSecond()).floatValue())));
        this.lastCapacityProvided = this.capacity;
        return stress.get().floatValue();
    }

    public int getRotationAngleOffset(Direction.Axis axis) {
        int combinedCoords = axis.m_7863_(this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_());
        return super.getRotationAngleOffset(axis) + (combinedCoords % 2 == 0 ? 180 : 0);
    }
}

