/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.blocks;

import com.jesz.createdieselgenerators.blocks.BlockRegistry;
import com.jesz.createdieselgenerators.blocks.ICDGKinetics;
import com.jesz.createdieselgenerators.blocks.PoweredEngineShaftBlock;
import com.jesz.createdieselgenerators.blocks.entity.BlockEntityRegistry;
import com.jesz.createdieselgenerators.blocks.entity.HugeDieselEngineBlockEntity;
import com.jesz.createdieselgenerators.blocks.entity.PoweredEngineShaftBlockEntity;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ShaftBlock;
import com.simibubi.create.content.kinetics.steamEngine.PoweredShaftBlock;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.simibubi.create.foundation.placement.IPlacementHelper;
import com.simibubi.create.foundation.placement.PlacementHelpers;
import com.simibubi.create.foundation.placement.PlacementOffset;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HugeDieselEngineBlock
extends Block
implements IBE<HugeDieselEngineBlockEntity>,
IWrenchable,
ICDGKinetics,
ProperWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());

    public HugeDieselEngineBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61368_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61369_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61370_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61371_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61366_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61367_, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        ItemStack heldItem = player.m_21120_(hand);
        IPlacementHelper placementHelper = PlacementHelpers.get((int)placementHelperId);
        if (placementHelper.matchesItem(heldItem)) {
            return placementHelper.getOffset(player, world, state, pos, ray).placeInWorld(world, (BlockItem)heldItem.m_41720_(), player, hand, ray);
        }
        return InteractionResult.PASS;
    }

    public FluidState m_5888_(BlockState pState) {
        return this.fluidState(pState);
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        this.updateWater(pLevel, pState, pCurrentPos);
        return pState;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, BlockStateProperties.f_61368_, BlockStateProperties.f_61369_, BlockStateProperties.f_61371_, BlockStateProperties.f_61370_, BlockStateProperties.f_61366_, BlockStateProperties.f_61367_, WATERLOGGED});
        super.m_7926_(builder);
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        HugeDieselEngineBlockEntity be;
        PoweredEngineShaftBlockEntity shaft;
        boolean c = (Boolean)state.m_61143_((Property)BooleanProperty.m_61465_((String)context.m_43719_().toString()));
        if (context.m_43719_().m_122434_() == ((Direction)state.m_61143_((Property)FACING)).m_122434_()) {
            return super.onWrenched(state, context);
        }
        BlockEntity blockEntity = context.m_43725_().m_7702_(context.m_8083_());
        if (blockEntity instanceof HugeDieselEngineBlockEntity && (shaft = (be = (HugeDieselEngineBlockEntity)blockEntity).getShaft()) != null) {
            shaft.removeGenerator(context.m_8083_());
        }
        context.m_43725_().m_7731_(context.m_8083_(), (BlockState)state.m_61124_((Property)BooleanProperty.m_61465_((String)context.m_43719_().toString()), (Comparable)Boolean.valueOf(!c)), 3);
        return InteractionResult.SUCCESS;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return Block.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos otherPos, boolean p_60514_) {
        if (((Boolean)state.m_61143_((Property)BooleanProperty.m_61465_((String)((Direction)state.m_61143_((Property)FACING)).toString()))).booleanValue() || ((Boolean)state.m_61143_((Property)BooleanProperty.m_61465_((String)((Direction)state.m_61143_((Property)FACING)).m_122424_().toString()))).booleanValue()) {
            level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)BooleanProperty.m_61465_((String)((Direction)state.m_61143_((Property)FACING)).toString()), (Comparable)Boolean.valueOf(false))).m_61124_((Property)BooleanProperty.m_61465_((String)((Direction)state.m_61143_((Property)FACING)).m_122424_().toString()), (Comparable)Boolean.valueOf(false)), 3);
        }
        super.m_6861_(state, level, pos, block, otherPos, p_60514_);
    }

    public Direction getPreferredFacing(BlockPlaceContext context) {
        Direction preferredSide = null;
        for (Direction side : Iterate.directions) {
            BlockState blockState = context.m_43725_().m_8055_(context.m_8083_().m_121945_(side));
            if (!(blockState.m_60734_() instanceof IRotate) || !((IRotate)blockState.m_60734_()).hasShaftTowards((LevelReader)context.m_43725_(), context.m_8083_().m_121945_(side), blockState, side.m_122424_())) continue;
            if (preferredSide != null && preferredSide.m_122434_() != side.m_122434_()) {
                preferredSide = null;
                break;
            }
            preferredSide = side;
        }
        return preferredSide;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction preferred = this.getPreferredFacing(context);
        if (preferred == null || context.m_43723_() != null && context.m_43723_().m_6144_()) {
            Direction nearestLookingDirection = context.m_7820_();
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)(context.m_43723_() != null && context.m_43723_().m_6144_() ? nearestLookingDirection : nearestLookingDirection.m_122424_()))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_192917_((Fluid)Fluids.f_76193_)));
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)preferred.m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_192917_((Fluid)Fluids.f_76193_)));
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        BlockPos shaftPos = pos.m_5484_((Direction)state.m_61143_((Property)FACING), 2);
        BlockState shaftState = level.m_8055_(shaftPos);
        if (shaftState.m_60734_() instanceof ShaftBlock && shaftState.m_61143_((Property)RotatedPillarKineticBlock.AXIS) != ((Direction)state.m_61143_((Property)FACING)).m_122434_()) {
            level.m_7731_(shaftPos, PoweredEngineShaftBlock.getEquivalent(shaftState), 3);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockPos shaftPos;
        BlockState shaftState;
        if (!(!state.m_155947_() || state.m_60713_(newState.m_60734_()) && newState.m_155947_())) {
            level.m_46747_(pos);
        }
        if (BlockRegistry.POWERED_ENGINE_SHAFT.has(shaftState = level.m_8055_(shaftPos = pos.m_5484_((Direction)state.m_61143_((Property)FACING), 2)))) {
            level.m_186460_(shaftPos, shaftState.m_60734_(), 1);
        }
    }

    public Class<HugeDieselEngineBlockEntity> getBlockEntityClass() {
        return HugeDieselEngineBlockEntity.class;
    }

    public BlockEntityType<? extends HugeDieselEngineBlockEntity> getBlockEntityType() {
        return (BlockEntityType)BlockEntityRegistry.HUGE_DIESEL_ENGINE.get();
    }

    @Override
    public float getDefaultStressCapacity() {
        return 2048.0f;
    }

    @Override
    public float getDefaultStressStressImpact() {
        return 0.0f;
    }

    @Override
    public float getDefaultSpeed() {
        return 96.0f;
    }

    private static class PlacementHelper
    implements IPlacementHelper {
        private PlacementHelper() {
        }

        public Predicate<ItemStack> getItemPredicate() {
            return arg_0 -> ((BlockEntry)AllBlocks.SHAFT).isIn(arg_0);
        }

        public Predicate<BlockState> getStatePredicate() {
            return s -> s.m_60734_() instanceof HugeDieselEngineBlock;
        }

        public PlacementOffset getOffset(Player player, Level level, BlockState state, BlockPos pos, BlockHitResult ray) {
            Direction direction;
            BlockPos shaftPos = pos.m_5484_((Direction)state.m_61143_((Property)FACING), 2);
            BlockState shaft = AllBlocks.SHAFT.getDefaultState();
            Direction[] directionArray = Direction.m_122382_((Entity)player);
            int n = directionArray.length;
            for (int i = 0; i < n && (shaft = (BlockState)shaft.m_61124_((Property)ShaftBlock.AXIS, (Comparable)(direction = directionArray[i]).m_122434_())).m_61143_((Property)RotatedPillarKineticBlock.AXIS) == ((Direction)state.m_61143_((Property)FACING)).m_122434_(); ++i) {
            }
            BlockState newState = level.m_8055_(shaftPos);
            if (!newState.m_247087_()) {
                return PlacementOffset.fail();
            }
            Direction.Axis axis = (Direction.Axis)shaft.m_61143_((Property)ShaftBlock.AXIS);
            return PlacementOffset.success((Vec3i)shaftPos, s -> (BlockState)BlockHelper.copyProperties((BlockState)s, (BlockState)BlockRegistry.POWERED_ENGINE_SHAFT.getDefaultState()).m_61124_((Property)PoweredShaftBlock.AXIS, (Comparable)axis));
        }
    }

    public static enum HugeEngineDirection implements StringRepresentable
    {
        BOTTOM,
        DOWN,
        MIDDLE,
        UP,
        TOP;


        public String m_7912_() {
            return Lang.asId((String)this.name());
        }
    }
}

