/*
 * Decompiled with CFR 0.152.
 */
package dev.bsmp.emotetweaks.voicefx;

import de.maxhenkel.voicechat.api.ForgeVoicechatPlugin;
import de.maxhenkel.voicechat.api.VoicechatApi;
import de.maxhenkel.voicechat.api.VoicechatPlugin;
import de.maxhenkel.voicechat.api.VoicechatServerApi;
import de.maxhenkel.voicechat.api.events.EventRegistration;
import de.maxhenkel.voicechat.api.events.VoicechatServerStartedEvent;
import dev.bsmp.emotetweaks.voicefx.SFXThread;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;

@ForgeVoicechatPlugin
public class SoundPlugin
implements VoicechatPlugin {
    public static VoicechatApi voicechatApi;
    public static VoicechatServerApi voicechatServerApi;
    private static List<SFXThread> runningThreads;

    public String getPluginId() {
        return "emotetweaks";
    }

    public void initialize(VoicechatApi api) {
        voicechatApi = api;
    }

    public void registerEvents(EventRegistration registration) {
        registration.registerEvent(VoicechatServerStartedEvent.class, this::onServerStarted);
    }

    public void onServerStarted(VoicechatServerStartedEvent event) {
        voicechatServerApi = event.getVoicechat();
    }

    public static void playSound(AudioInputStream stream) {
        try {
            SFXThread thread = SFXThread.playSFX(stream);
            runningThreads.add(thread);
            thread.startPlaying();
        }
        catch (IOException | UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
    }

    public static void stopSounds() {
        for (SFXThread thread : runningThreads) {
            thread.interrupt();
        }
        runningThreads.clear();
    }

    static {
        runningThreads = new ArrayList<SFXThread>();
    }
}

