/*
 * Decompiled with CFR 0.152.
 */
package dev.bsmp.emotetweaks.emotetweaks.mixin;

import dev.bsmp.emotetweaks.emotetweaks.SoundFrame;
import dev.bsmp.emotetweaks.util.EmoteProperties;
import dev.bsmp.emotetweaks.voicefx.SoundPlugin;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import io.github.kosmx.emotes.executor.EmoteInstance;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={KeyframeAnimationPlayer.class}, remap=false)
public class KeyframeAnimationPlayerMixin {
    @Shadow
    private boolean isRunning;
    @Shadow
    @Final
    private KeyframeAnimation data;
    @Shadow
    private int currentTick;
    private List<SoundFrame> soundFrames;
    private SoundFrame nextSound;
    private Map<String, short[]> audioFiles = new HashMap<String, short[]>();

    @Inject(method={"<init>(Ldev/kosmx/playerAnim/core/data/KeyframeAnimation;I)V"}, at={@At(value="TAIL")})
    private void onConstruct(KeyframeAnimation emote, int t, CallbackInfo ci) {
        Path autoFile;
        if (emote.extraData.containsKey("name") && (autoFile = EmoteProperties.getGameDir().resolve("emotes" + FileSystems.getDefault().getSeparator() + ((String)emote.extraData.get("name")).replace("\"", "") + ".wav")).toFile().exists()) {
            try {
                AudioInputStream stream = this.loadAudioFile(autoFile);
                if (stream != null) {
                    SoundPlugin.playSound(stream);
                }
            }
            catch (IOException | UnsupportedAudioFileException e) {
                e.printStackTrace();
            }
        }
    }

    private AudioInputStream loadAudioFile(String name) throws UnsupportedAudioFileException, IOException {
        return this.loadAudioFile(EmoteProperties.getGameDir().resolve("emotes" + FileSystems.getDefault().getSeparator() + name));
    }

    private AudioInputStream loadAudioFile(Path path) throws UnsupportedAudioFileException, IOException {
        AudioInputStream input = AudioSystem.getAudioInputStream(path.toFile());
        AudioInputStream formattedInput = AudioSystem.getAudioInputStream(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 48000.0f, 16, 1, 2, 48000.0f, false), input);
        return formattedInput;
    }

    @Inject(method={"stop"}, at={@At(value="TAIL")})
    private void stopSounds(CallbackInfo ci) {
        if (this == EmoteInstance.instance.getClientMethods().getMainPlayer().getEmote()) {
            SoundPlugin.stopSounds();
        }
    }
}

