/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.common.config.options;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import org.anti_ad.mc.common.config.ConfigOptionBase;
import org.anti_ad.mc.common.config.IConfigOptionPrimitive;
import org.anti_ad.mc.common.extensions.JsonKt;
import org.anti_ad.mc.common.extensions.StringKt;
import org.anti_ad.mc.common.vanilla.render.ColorKt;
import org.anti_ad.mc.libipn.Log;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0012\u001a\u00020\u0000J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u0007\"\u0004\b\n\u0010\u0005R$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lorg/anti_ad/mc/common/config/options/ConfigColorPicker;", "Lorg/anti_ad/mc/common/config/ConfigOptionBase;", "Lorg/anti_ad/mc/common/config/IConfigOptionPrimitive;", "", "defaultValue", "(I)V", "getDefaultValue", "()Ljava/lang/Integer;", "value", "getValue", "setValue", "v", "", "valueAsString", "getValueAsString", "()Ljava/lang/String;", "setValueAsString", "(Ljava/lang/String;)V", "copy", "fromJsonElement", "", "element", "Lkotlinx/serialization/json/JsonElement;", "toJsonElement", "libIPN"})
public final class ConfigColorPicker
extends ConfigOptionBase
implements IConfigOptionPrimitive<Integer> {
    private final int defaultValue;
    private int value;

    public ConfigColorPicker(int defaultValue) {
        this.defaultValue = defaultValue;
        this.value = this.getDefaultValue();
    }

    @Override
    @NotNull
    public Integer getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    @NotNull
    public Integer getValue() {
        return this.value;
    }

    @Override
    public void setValue(int n) {
        this.value = n;
    }

    private final String getValueAsString() {
        return ColorKt.htmlColor(this.getValue());
    }

    private final void setValueAsString(String v) {
        this.setValue(StringKt.htmlColorToMinecraftColor(v, this.getDefaultValue()));
    }

    @Override
    @NotNull
    public JsonElement toJsonElement() {
        return (JsonElement)JsonKt.toJsonPrimitive(this.getValueAsString());
    }

    @Override
    public void fromJsonElement(@NotNull JsonElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.resetToDefault();
        try {
            this.setValueAsString(JsonKt.value(JsonElementKt.getJsonPrimitive((JsonElement)element), ColorKt.htmlColor(this.getDefaultValue())));
        }
        catch (Exception e) {
            Log.INSTANCE.warn("Failed to set config value for '" + this.getKey() + "' from the JSON element '" + element + "'");
        }
    }

    @NotNull
    public final ConfigColorPicker copy() {
        ConfigColorPicker configColorPicker;
        ConfigColorPicker $this$copy_u24lambda_u240 = configColorPicker = new ConfigColorPicker(this.getDefaultValue());
        boolean bl = false;
        $this$copy_u24lambda_u240.setValue(this.getValue());
        return configColorPicker;
    }

    @Override
    public boolean isModified() {
        return IConfigOptionPrimitive.DefaultImpls.isModified(this);
    }

    @Override
    public void resetToDefault() {
        IConfigOptionPrimitive.DefaultImpls.resetToDefault(this);
    }
}

