/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds;

import java.lang.reflect.Field;
import team.creative.ambientsounds.AmbientCondition;
import team.creative.ambientsounds.AmbientSoundProperties;
import team.creative.ambientsounds.AmbientVolume;

public class AmbientSelection
extends AmbientVolume {
    public final AmbientCondition condition;
    public AmbientSelection subSelection = null;

    public AmbientSelection(AmbientCondition condition) {
        super(1.0, condition.volume);
        this.condition = condition;
    }

    @Override
    public double conditionVolume() {
        return this.subSelection != null ? this.subSelection.conditionVolume() * super.conditionVolume() : super.conditionVolume();
    }

    @Override
    public double settingVolume() {
        return this.subSelection != null ? this.subSelection.settingVolume() * super.settingVolume() : super.settingVolume();
    }

    @Override
    public double volume() {
        return this.subSelection != null ? this.subSelection.volume() * super.volume() : super.volume();
    }

    public AmbientSelection last() {
        if (this.subSelection == null) {
            return this;
        }
        return this.subSelection.last();
    }

    public AmbientSoundProperties getProperties() {
        AmbientSoundProperties properties = new AmbientSoundProperties();
        this.assignProperties(properties);
        return properties;
    }

    protected void assignProperties(AmbientSoundProperties properties) {
        try {
            for (Field field : AmbientSoundProperties.class.getFields()) {
                Object value = field.get(this.condition);
                if (value == null) continue;
                field.set(properties, value);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        if (this.subSelection != null) {
            this.subSelection.assignProperties(properties);
        }
    }
}

