/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.template.variable;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.world.item.ItemStack;
import vazkii.patchouli.client.book.template.variable.GenericArrayVariableSerializer;
import vazkii.patchouli.client.book.template.variable.ItemStackVariableSerializer;
import vazkii.patchouli.common.util.ItemStackUtil;

public class ItemStackArrayVariableSerializer
extends GenericArrayVariableSerializer<ItemStack> {
    public ItemStackArrayVariableSerializer() {
        super(new ItemStackVariableSerializer(), ItemStack.class);
    }

    @Override
    public ItemStack[] fromJson(JsonElement json) {
        if (json.isJsonArray()) {
            JsonArray array = json.getAsJsonArray();
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (JsonElement e : array) {
                stacks.addAll(Arrays.asList(this.fromNonArray(e)));
            }
            return stacks.toArray((ItemStack[])this.empty);
        }
        return this.fromNonArray(json);
    }

    public ItemStack[] fromNonArray(JsonElement json) {
        if (json.isJsonNull()) {
            return (ItemStack[])this.empty;
        }
        if (json.isJsonPrimitive()) {
            return ItemStackUtil.loadStackListFromString(json.getAsString()).toArray((ItemStack[])this.empty);
        }
        if (json.isJsonObject()) {
            return new ItemStack[]{ItemStackUtil.loadStackFromJson(json.getAsJsonObject())};
        }
        throw new IllegalArgumentException("Can't make an ItemStack from an array!");
    }
}

