/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.transfer;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntLinkedOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.RoughlyEnoughItemsNetwork;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.client.registry.transfer.simple.SimpleTransferHandler;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.InputIngredient;
import me.shedaniel.rei.api.common.transfer.RecipeFinder;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessorRegistry;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.impl.ClientInternals;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public enum SimpleTransferHandlerImpl implements ClientInternals.SimpleTransferHandler
{
    INSTANCE;


    @Override
    public TransferHandler.Result handle(TransferHandler.Context context, SimpleTransferHandler.MissingInputRenderer missingInputRenderer, List<InputIngredient<ItemStack>> inputs, Iterable<SlotAccessor> inputSlots, Iterable<SlotAccessor> inventorySlots) {
        AbstractContainerScreen<?> containerScreen = context.getContainerScreen();
        List<InputIngredient<ItemStack>> missing = SimpleTransferHandlerImpl.hasItemsIndexed(context, inventorySlots, inputs);
        if (!missing.isEmpty()) {
            IntLinkedOpenHashSet missingIndices = new IntLinkedOpenHashSet(missing.size());
            for (InputIngredient<ItemStack> ingredient2 : missing) {
                missingIndices.add(ingredient2.getDisplayIndex());
            }
            return TransferHandler.Result.createFailed((Component)Component.m_237115_((String)"error.rei.not.enough.materials")).renderer((arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> SimpleTransferHandlerImpl.lambda$handle$0(missingInputRenderer, context, inputs, missing, (IntSet)missingIndices, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6)).tooltipMissing(CollectionUtils.map(missing, ingredient -> EntryIngredients.ofItemStacks(ingredient.get())));
        }
        if (!ClientHelper.getInstance().canUseMovePackets()) {
            return TransferHandler.Result.createFailed((Component)Component.m_237115_((String)"error.rei.not.on.server"));
        }
        if (!context.isActuallyCrafting()) {
            return TransferHandler.Result.createSuccessful();
        }
        context.getMinecraft().m_91152_(containerScreen);
        if (containerScreen instanceof RecipeUpdateListener) {
            RecipeUpdateListener listener = (RecipeUpdateListener)containerScreen;
            listener.m_5564_().f_100269_.m_100140_();
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130085_(context.getDisplay().getCategoryIdentifier().getIdentifier());
        buf.writeBoolean(context.isStackedCrafting());
        buf.m_130079_(this.save(context, inputs, inputSlots, inventorySlots));
        NetworkManager.sendToServer((ResourceLocation)RoughlyEnoughItemsNetwork.MOVE_ITEMS_NEW_PACKET, (FriendlyByteBuf)buf);
        return TransferHandler.Result.createSuccessful();
    }

    private CompoundTag save(TransferHandler.Context context, List<InputIngredient<ItemStack>> inputs, Iterable<SlotAccessor> inputSlots, Iterable<SlotAccessor> inventorySlots) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("Version", 1);
        tag.m_128365_("Inputs", this.saveInputs(inputs));
        tag.m_128365_("InventorySlots", this.saveSlots(context, inventorySlots));
        tag.m_128365_("InputSlots", this.saveSlots(context, inputSlots));
        return tag;
    }

    private Tag saveSlots(TransferHandler.Context context, Iterable<SlotAccessor> slots) {
        ListTag tag = new ListTag();
        for (SlotAccessor slot : slots) {
            tag.add((Object)SlotAccessorRegistry.getInstance().save(context.getMenu(), (Player)context.getMinecraft().f_91074_, slot));
        }
        return tag;
    }

    private Tag saveInputs(List<InputIngredient<ItemStack>> inputs) {
        ListTag tag = new ListTag();
        for (InputIngredient<ItemStack> input : inputs) {
            CompoundTag innerTag = new CompoundTag();
            innerTag.m_128365_("Ingredient", (Tag)EntryIngredients.ofItemStacks(input.get()).saveIngredient());
            innerTag.m_128405_("Index", input.getIndex());
            tag.add((Object)innerTag);
        }
        return tag;
    }

    public static List<InputIngredient<ItemStack>> hasItemsIndexed(TransferHandler.Context context, Iterable<SlotAccessor> inventorySlots, List<InputIngredient<ItemStack>> inputs) {
        RecipeFinder recipeFinder = new RecipeFinder();
        for (SlotAccessor slot : inventorySlots) {
            recipeFinder.addNormalItem(slot.getItemStack());
        }
        ArrayList<InputIngredient<ItemStack>> missing = new ArrayList<InputIngredient<ItemStack>>();
        for (InputIngredient<ItemStack> possibleStacks : inputs) {
            boolean done = possibleStacks.get().isEmpty();
            for (ItemStack possibleStack : possibleStacks.get()) {
                int invRequiredCount;
                if (done) continue;
                int key = RecipeFinder.getItemId(possibleStack);
                for (invRequiredCount = possibleStack.m_41613_(); invRequiredCount > 0 && recipeFinder.contains(key); --invRequiredCount) {
                    recipeFinder.take(key, 1);
                }
                if (invRequiredCount > 0) continue;
                done = true;
                break;
            }
            if (done) continue;
            missing.add(possibleStacks);
        }
        return missing;
    }

    private static /* synthetic */ void lambda$handle$0(SimpleTransferHandler.MissingInputRenderer missingInputRenderer, TransferHandler.Context context, List inputs, List missing, IntSet missingIndices, GuiGraphics matrices, int mouseX, int mouseY, float delta, List widgets, Rectangle bounds, Display d) {
        missingInputRenderer.renderMissingInput(context, inputs, missing, missingIndices, matrices, mouseX, mouseY, delta, widgets, bounds);
    }
}

