/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco.blocks;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CatwalkRailingBlock
extends Block
implements IWrenchable,
SimpleWaterloggedBlock {
    private static final VoxelShape VOXEL_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)2.0);
    private static final VoxelShape VOXEL_SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)14.0, (double)16.0);
    private static final VoxelShape VOXEL_EAST = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);
    private static final VoxelShape VOXEL_WEST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0);
    public static final BooleanProperty NORTH_FENCE = BlockStateProperties.f_61368_;
    public static final BooleanProperty SOUTH_FENCE = BlockStateProperties.f_61370_;
    public static final BooleanProperty EAST_FENCE = BlockStateProperties.f_61369_;
    public static final BooleanProperty WEST_FENCE = BlockStateProperties.f_61371_;

    public CatwalkRailingBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)NORTH_FENCE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH_FENCE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST_FENCE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST_FENCE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        BlockPos pos = context.m_8083_();
        Vec3 subbox = context.m_43720_().m_82546_(pos.m_252807_());
        Direction face = context.m_43719_();
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        double x = subbox.f_82479_;
        double z = subbox.f_82481_;
        if (level instanceof ClientLevel) {
            return InteractionResult.PASS;
        }
        if (face == Direction.UP) {
            boolean bottomleft = x < -z;
            boolean topleft = x < z;
            Direction dir = Direction.WEST;
            if (!bottomleft && topleft) {
                dir = Direction.SOUTH;
            }
            if (!bottomleft && !topleft) {
                dir = Direction.EAST;
            }
            if (bottomleft && !topleft) {
                dir = Direction.NORTH;
            }
            if (bottomleft && topleft) {
                dir = Direction.WEST;
            }
            if (((Boolean)state.m_61143_((Property)CatwalkRailingBlock.fromDirection(dir))).booleanValue()) {
                state = (BlockState)state.m_61124_((Property)CatwalkRailingBlock.fromDirection(dir), (Comparable)Boolean.valueOf(false));
                level.m_7731_(pos, state, 3);
                this.playRemoveSound(level, pos);
                if (!player.m_150110_().f_35937_) {
                    player.m_36356_(new ItemStack((ItemLike)state.m_60734_().m_5456_()));
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        if (x == 0.375 || x == -0.375 || z == 0.375 || z == -0.375) {
            state = (BlockState)state.m_61124_((Property)CatwalkRailingBlock.fromDirection(face.m_122424_()), (Comparable)Boolean.valueOf(false));
        }
        if (x == 0.5 || x == -0.5 || z == 0.5 || z == -0.5) {
            if (!((Boolean)state.m_61143_((Property)CatwalkRailingBlock.fromDirection(face))).booleanValue()) {
                if (x >= 0.375) {
                    state = (BlockState)state.m_61124_((Property)EAST_FENCE, (Comparable)Boolean.valueOf(false));
                }
                if (x <= -0.375) {
                    state = (BlockState)state.m_61124_((Property)WEST_FENCE, (Comparable)Boolean.valueOf(false));
                }
                if (z <= -0.375) {
                    state = (BlockState)state.m_61124_((Property)NORTH_FENCE, (Comparable)Boolean.valueOf(false));
                }
                if (z >= 0.375) {
                    state = (BlockState)state.m_61124_((Property)SOUTH_FENCE, (Comparable)Boolean.valueOf(false));
                }
            } else {
                state = (BlockState)state.m_61124_((Property)CatwalkRailingBlock.fromDirection(face), (Comparable)Boolean.valueOf(false));
            }
        }
        level.m_7731_(pos, state, 3);
        this.playRemoveSound(level, pos);
        if (!player.m_150110_().f_35937_) {
            player.m_36356_(new ItemStack((ItemLike)state.m_60734_().m_5456_()));
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction facing = ctx.m_8125_();
        FluidState fluid = ctx.m_43725_().m_6425_(ctx.m_8083_());
        BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)NORTH_FENCE, (Comparable)Boolean.valueOf(facing == Direction.NORTH))).m_61124_((Property)SOUTH_FENCE, (Comparable)Boolean.valueOf(facing == Direction.SOUTH))).m_61124_((Property)EAST_FENCE, (Comparable)Boolean.valueOf(facing == Direction.EAST))).m_61124_((Property)WEST_FENCE, (Comparable)Boolean.valueOf(facing == Direction.WEST))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(fluid.m_76152_() == Fluids.f_76193_));
        return state;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{NORTH_FENCE});
        builder.m_61104_(new Property[]{SOUTH_FENCE});
        builder.m_61104_(new Property[]{EAST_FENCE});
        builder.m_61104_(new Property[]{WEST_FENCE});
        builder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
    }

    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        if (targetedFace.m_122434_() == Direction.Axis.Y) {
            int state = ((Boolean)originalState.m_61143_((Property)NORTH_FENCE) != false ? 8 : 0) + ((Boolean)originalState.m_61143_((Property)EAST_FENCE) != false ? 4 : 0) + ((Boolean)originalState.m_61143_((Property)SOUTH_FENCE) != false ? 2 : 0) + ((Boolean)originalState.m_61143_((Property)WEST_FENCE) != false ? 1 : 0);
            return (BlockState)((BlockState)((BlockState)((BlockState)originalState.m_61124_((Property)NORTH_FENCE, (Comparable)Boolean.valueOf((state & 1) == 1))).m_61124_((Property)EAST_FENCE, (Comparable)Boolean.valueOf((state & 8) == 8))).m_61124_((Property)SOUTH_FENCE, (Comparable)Boolean.valueOf((state & 4) == 4))).m_61124_((Property)WEST_FENCE, (Comparable)Boolean.valueOf((state & 2) == 2));
        }
        return originalState;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext ctx) {
        return this.m_6079_(state, reader, pos);
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter world, BlockPos pos) {
        VoxelShape shape = Shapes.m_83040_();
        if (((Boolean)state.m_61143_((Property)NORTH_FENCE)).booleanValue()) {
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)VOXEL_NORTH, (BooleanOp)BooleanOp.f_82695_);
        }
        if (((Boolean)state.m_61143_((Property)SOUTH_FENCE)).booleanValue()) {
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)VOXEL_SOUTH, (BooleanOp)BooleanOp.f_82695_);
        }
        if (((Boolean)state.m_61143_((Property)EAST_FENCE)).booleanValue()) {
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)VOXEL_EAST, (BooleanOp)BooleanOp.f_82695_);
        }
        if (((Boolean)state.m_61143_((Property)WEST_FENCE)).booleanValue()) {
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)VOXEL_WEST, (BooleanOp)BooleanOp.f_82695_);
        }
        return shape;
    }

    public boolean m_6044_(BlockGetter world, BlockPos pos, BlockState state, Fluid fluid) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) == false && fluid == Fluids.f_76193_;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        if (CatwalkRailingBlock.isEmpty(state)) {
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 0);
        }
        super.m_6861_(state, level, pos, neighborBlock, neighborPos, movedByPiston);
    }

    public static boolean isRailing(ItemStack test) {
        return test.m_41720_() instanceof BlockItem && CatwalkRailingBlock.isRailing(((BlockItem)test.m_41720_()).m_40614_());
    }

    public static boolean isRailing(Block test) {
        return test instanceof CatwalkRailingBlock;
    }

    public static BooleanProperty fromDirection(Direction face) {
        return switch (face) {
            case Direction.SOUTH -> SOUTH_FENCE;
            case Direction.EAST -> EAST_FENCE;
            case Direction.WEST -> WEST_FENCE;
            default -> NORTH_FENCE;
        };
    }

    public static boolean isEmpty(BlockState state) {
        boolean safe = false;
        for (Direction dir : BlockStateProperties.f_61374_.m_6908_()) {
            safe |= ((Boolean)state.m_61143_((Property)CatwalkRailingBlock.fromDirection(dir))).booleanValue();
        }
        return !safe;
    }
}

