/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco.api;

import com.github.talrey.createdeco.api.LoaderTag;
import java.util.HashMap;
import java.util.Locale;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class CDTags {
    private static final HashMap<Material, HashMap<Form, LoaderTag<Item>>> tags = new HashMap();
    public static final TagKey<Item> PLACARD = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("createdeco", "placards"));
    public static final LoaderTag<Item> GLASS_ITEM = LoaderTag.same(Registries.f_256913_, "colorless_glass");
    public static final LoaderTag<Item> GLASS_PANE_ITEM = LoaderTag.same(Registries.f_256913_, "colorless_glass_panes");
    public static final LoaderTag<Block> GLASS = LoaderTag.same(Registries.f_256747_, "colorless_glass");
    public static final LoaderTag<Block> GLASS_PANE = LoaderTag.same(Registries.f_256747_, "colorless_glass_panes");
    public static final LoaderTag<Block> STORAGE;
    public static final LoaderTag<Block> INDUSTRIAL_IRON_BLOCK;

    private static void init() {
        for (Material m : Material.values()) {
            tags.put(m, new HashMap());
            for (Form f : Form.values()) {
                tags.get((Object)m).put(f, CDTags.item(f.toString(), m.toString()));
            }
        }
    }

    public static LoaderTag<Item> of(String material, String form) {
        Material m = Material.valueOf(material.toLowerCase(Locale.ROOT).replaceAll(" ", "_"));
        Form f = Form.valueOf(form.toLowerCase(Locale.ROOT));
        if (tags.containsKey((Object)m) && tags.get((Object)m).containsKey((Object)f)) {
            return tags.get((Object)m).get((Object)f);
        }
        return tags.get((Object)Material.iron).get((Object)Form.ingots);
    }

    private static LoaderTag<Item> item(String type, String name) {
        String forge = type + "/" + name;
        String fabric = name + "_" + type;
        String common = forge + "_" + type;
        return LoaderTag.standard(Registries.f_256913_, common, forge, fabric);
    }

    private static LoaderTag<Block> block(String type, String name) {
        String forge = type + "/" + name;
        String fabric = name + "_" + type;
        String common = forge + "_" + type;
        return LoaderTag.standard(Registries.f_256747_, common, forge, fabric);
    }

    private static LoaderTag<Block> block(String type) {
        return LoaderTag.same(Registries.f_256747_, type);
    }

    static {
        CDTags.init();
        STORAGE = CDTags.block("storage_blocks");
        INDUSTRIAL_IRON_BLOCK = CDTags.block("storage_blocks", "industrial_iron");
    }

    private static enum Material {
        andesite,
        iron,
        gold,
        copper,
        zinc,
        brass,
        industrial_iron,
        netherite;

    }

    private static enum Form {
        nuggets,
        ingots,
        plates,
        blocks;

    }
}

