/*
 * Decompiled with CFR 0.152.
 */
package artifacts.forge.mixin.item.wearable;

import artifacts.Artifacts;
import artifacts.item.wearable.AttributeModifyingItem;
import artifacts.item.wearable.WearableArtifactItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import top.theillusivec4.curios.api.CuriosApi;

@Mixin(value={AttributeModifyingItem.class})
public abstract class AttributeModifyingItemMixin
extends WearableArtifactItem {
    @Shadow
    @Final
    private Attribute attribute;

    @Shadow
    public abstract double getAmount();

    @Shadow
    public abstract AttributeModifier.Operation getOperation();

    @Override
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltipList, TooltipFlag flags) {
        super.m_7373_(stack, world, tooltipList, flags);
        Set curioTags = CuriosApi.getCuriosHelper().getCurioTags(stack.m_41720_());
        ArrayList slots = new ArrayList(curioTags);
        if (Artifacts.CONFIG.client.showTooltips && !this.isCosmetic() && !slots.isEmpty()) {
            tooltipList.add((Component)Component.m_237119_());
            String identifier = slots.contains("curio") ? "curio" : (String)slots.get(0);
            tooltipList.add((Component)Component.m_237115_((String)("curios.modifiers." + identifier)));
            double amount = this.getAmount();
            if (this.getOperation() == AttributeModifier.Operation.ADDITION) {
                if (this.attribute.equals(Attributes.f_22278_)) {
                    amount *= 10.0;
                }
            } else {
                amount *= 100.0;
            }
            tooltipList.add((Component)Component.m_237110_((String)("attribute.modifier.plus." + this.getOperation().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(amount), Component.m_237115_((String)this.attribute.m_22087_())}).m_130940_(ChatFormatting.BLUE));
        }
    }
}

