/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.type.list;

import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class CopyArrayCollection<E>
implements Collection<E>,
Cloneable {
    private static final int DEFAULT_CAPACITY = 10;
    private static final Object[] EMPTY_ELEMENTDATA = new Object[0];
    private static final Object[] DEFAULTCAPACITY_EMPTY_ELEMENTDATA = new Object[0];
    public static final int SOFT_MAX_ARRAY_LENGTH = 0x7FFFFFF7;
    private Object[] content;
    private int size;
    private boolean hadIterator = false;

    public static int newLength(int oldLength, int minGrowth, int prefGrowth) {
        int prefLength = oldLength + Math.max(minGrowth, prefGrowth);
        if (0 < prefLength && prefLength <= 0x7FFFFFF7) {
            return prefLength;
        }
        return CopyArrayCollection.hugeLength(oldLength, minGrowth);
    }

    private static int hugeLength(int oldLength, int minGrowth) {
        int minLength = oldLength + minGrowth;
        if (minLength < 0) {
            throw new OutOfMemoryError("Required array length " + oldLength + " + " + minGrowth + " is too large");
        }
        if (minLength <= 0x7FFFFFF7) {
            return 0x7FFFFFF7;
        }
        return minLength;
    }

    public CopyArrayCollection() {
        this.content = DEFAULTCAPACITY_EMPTY_ELEMENTDATA;
        this.size = 0;
    }

    public CopyArrayCollection(int initialCapacity) {
        if (initialCapacity > 0) {
            this.content = new Object[initialCapacity];
        } else if (initialCapacity == 0) {
            this.content = EMPTY_ELEMENTDATA;
        } else {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.size = 0;
    }

    public CopyArrayCollection(E element) {
        this(1);
        this.content[0] = element;
        this.size = 1;
    }

    public CopyArrayCollection(Collection<? extends E> c) {
        this.content = c instanceof CopyArrayCollection ? Arrays.copyOf(((CopyArrayCollection)c).content, ((CopyArrayCollection)c).content.length, Object[].class) : c.toArray(new Object[c.size()]);
        this.size = c.size();
    }

    public CopyArrayCollection(Iterable<? extends E> c) {
        this();
        c.forEach(this::add);
    }

    public CopyArrayCollection(E ... toCopyIn) {
        this.content = Arrays.copyOf(toCopyIn, toCopyIn.length, Object[].class);
        this.size = this.content.length;
    }

    public synchronized void trimToSize() {
        if (this.size < this.content.length) {
            this.hadIterator = false;
            this.content = this.size == 0 ? EMPTY_ELEMENTDATA : Arrays.copyOf(this.content, this.size);
        }
    }

    public void ensureCapacity(int minCapacity) {
        if (minCapacity > this.content.length && (this.content != DEFAULTCAPACITY_EMPTY_ELEMENTDATA || minCapacity > 10)) {
            this.grow(minCapacity);
        }
    }

    private Object[] grow(int minCapacity) {
        int oldCapacity = this.content.length;
        if (oldCapacity > 0 || this.content != DEFAULTCAPACITY_EMPTY_ELEMENTDATA) {
            int newCapacity = CopyArrayCollection.newLength(oldCapacity, minCapacity - oldCapacity, oldCapacity >> 1);
            this.hadIterator = false;
            this.content = Arrays.copyOf(this.content, newCapacity);
            return this.content;
        }
        this.hadIterator = false;
        this.content = new Object[Math.max(10, minCapacity)];
        return this.content;
    }

    private Object[] grow() {
        return this.grow(this.size + 1);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E first() {
        int size;
        Object[] es;
        CopyArrayCollection copyArrayCollection = this;
        synchronized (copyArrayCollection) {
            es = this.content;
            size = this.size;
        }
        if (size > 0) {
            return (E)es[0];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        int size;
        Object[] es;
        CopyArrayCollection copyArrayCollection = this;
        synchronized (copyArrayCollection) {
            es = this.content;
            size = this.size;
        }
        return this.indexOfRange(o, es, 0, size) >= 0;
    }

    int indexOfRange(Object o, Object[] es, int start, int end) {
        if (o == null) {
            for (int i = start; i < end; ++i) {
                if (es[i] != null) continue;
                return i;
            }
        } else {
            for (int i = start; i < end; ++i) {
                if (!o.equals(es[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public Object clone() {
        return new CopyArrayCollection<E>(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        int size;
        Object[] es;
        CopyArrayCollection copyArrayCollection = this;
        synchronized (copyArrayCollection) {
            es = this.content;
            size = this.size;
        }
        return Arrays.copyOf(es, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        int len;
        Object[] es;
        CopyArrayCollection copyArrayCollection = this;
        synchronized (copyArrayCollection) {
            es = this.content;
            len = es.length;
        }
        if (a.length < len) {
            return Arrays.copyOf(es, len, a.getClass());
        }
        System.arraycopy(es, 0, a, 0, len);
        if (a.length > len) {
            a[len] = null;
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E e) {
        CopyArrayCollection copyArrayCollection = this;
        synchronized (copyArrayCollection) {
            Object[] es = this.content;
            int size = this.size;
            if (size == es.length) {
                es = this.grow();
            }
            es[size] = e;
            this.size = size + 1;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        CopyArrayCollection copyArrayCollection = this;
        synchronized (copyArrayCollection) {
            if (this.hadIterator) {
                this.hadIterator = false;
                this.content = DEFAULTCAPACITY_EMPTY_ELEMENTDATA;
                this.size = 0;
            } else {
                Object[] es = this.content;
                int to = this.size;
                this.size = 0;
                for (int i = 0; i < to; ++i) {
                    es[i] = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (c.isEmpty()) {
            return false;
        }
        CopyArrayCollection copyArrayCollection = this;
        synchronized (copyArrayCollection) {
            if (this.hadIterator) {
                Object[] cs = c.toArray();
                Object[] es = this.content;
                int len = this.size;
                int newSize = len + cs.length;
                Object[] newElements = Arrays.copyOf(es, newSize);
                System.arraycopy(cs, 0, newElements, len, cs.length);
                this.hadIterator = false;
                this.content = newElements;
                this.size = newSize;
            } else {
                Object[] a = c.toArray();
                int numNew = a.length;
                Object[] elementData = this.content;
                int s = this.size;
                if (numNew > this.content.length - s) {
                    elementData = this.grow(s + numNew);
                }
                System.arraycopy(a, 0, elementData, s, numNew);
                this.content = elementData;
                this.size = s + numNew;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> c) {
        int size;
        Object[] es;
        CopyArrayCollection copyArrayCollection = this;
        synchronized (copyArrayCollection) {
            es = this.content;
            size = this.size;
        }
        for (Object o : c) {
            if (this.indexOfRange(o, es, 0, size) >= 0) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<E> iterator() {
        int size;
        Object[] es;
        CopyArrayCollection copyArrayCollection = this;
        synchronized (copyArrayCollection) {
            es = this.content;
            size = this.size;
            this.hadIterator = true;
        }
        return new Iterator<E>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < size;
            }

            @Override
            public E next() {
                Object result = es[this.index];
                ++this.index;
                return result;
            }

            @Override
            public void remove() {
                CopyArrayCollection.this.remove(es[this.index]);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        CopyArrayCollection copyArrayCollection = this;
        synchronized (copyArrayCollection) {
            Object[] snapshot = this.content;
            int index = this.indexOfRange(o, snapshot, 0, snapshot.length);
            return index >= 0 && this.remove(o, snapshot, index);
        }
    }

    private boolean remove(Object o, Object[] snapshot, int index) {
        if (this.hadIterator) {
            Object[] current = this.content;
            int len = this.size--;
            Object[] newElements = new Object[len - 1];
            System.arraycopy(current, 0, newElements, 0, index);
            System.arraycopy(current, index + 1, newElements, index, len - index - 1);
            this.hadIterator = false;
            this.content = newElements;
            return true;
        }
        Object[] es = this.content;
        this.fastRemove(es, index);
        return true;
    }

    private synchronized void fastRemove(Object[] es, int i) {
        int newSize = this.size - 1;
        if (newSize > i) {
            System.arraycopy(es, i + 1, es, i, newSize - i);
        }
        es[--this.size] = null;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        Objects.requireNonNull(c);
        return this.bulkRemove(e -> c.contains(e));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Objects.requireNonNull(c);
        return this.bulkRemove(e -> !c.contains(e));
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        Objects.requireNonNull(filter);
        return this.bulkRemove(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean bulkRemove(Predicate<? super E> filter) {
        CopyArrayCollection copyArrayCollection = this;
        synchronized (copyArrayCollection) {
            return this.bulkRemove(filter, 0, this.size);
        }
    }

    private static long[] nBits(int n) {
        return new long[(n - 1 >> 6) + 1];
    }

    private static void setBit(long[] bits, int i) {
        int n = i >> 6;
        bits[n] = bits[n] | 1L << i;
    }

    private static boolean isClear(long[] bits, int i) {
        return (bits[i >> 6] & 1L << i) == 0L;
    }

    boolean bulkRemove(Predicate<? super E> filter, int i, int end) {
        Object[] es = this.content;
        while (i < end && !filter.test(es[i])) {
            ++i;
        }
        if (i < end) {
            int beg = i;
            long[] deathRow = CopyArrayCollection.nBits(end - beg);
            int deleted = 1;
            deathRow[0] = 1L;
            for (i = beg + 1; i < end; ++i) {
                if (!filter.test(es[i])) continue;
                CopyArrayCollection.setBit(deathRow, i - beg);
                ++deleted;
            }
            if (es != this.content) {
                throw new ConcurrentModificationException();
            }
            Object[] newElts = Arrays.copyOf(es, es.length - deleted);
            int w = beg;
            for (i = beg; i < end; ++i) {
                if (!CopyArrayCollection.isClear(deathRow, i - beg)) continue;
                newElts[w++] = es[i];
            }
            System.arraycopy(es, i, newElts, w, es.length - i);
            this.hadIterator = false;
            this.content = newElts;
            this.size = newElts.length;
            return true;
        }
        if (es != this.content) {
            throw new ConcurrentModificationException();
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List list = (List)o;
        Iterator it = list.iterator();
        for (Object element : this.content) {
            if (it.hasNext() && Objects.equals(element, it.next())) continue;
            return false;
        }
        return !it.hasNext();
    }

    private static int hashCodeOfRange(Object[] es, int from, int to) {
        int hashCode = 1;
        for (int i = from; i < to; ++i) {
            Object x = es[i];
            hashCode = 31 * hashCode + (x == null ? 0 : x.hashCode());
        }
        return hashCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        int size;
        Object[] es;
        CopyArrayCollection copyArrayCollection = this;
        synchronized (copyArrayCollection) {
            es = this.content;
            size = this.size;
        }
        return CopyArrayCollection.hashCodeOfRange(es, 0, size);
    }

    public String toString() {
        Iterator<E> it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            E e;
            sb.append((Object)((e = it.next()) == this ? "(this Collection)" : e));
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }
}

