/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.manager;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.CreativeCoreGuiRegistry;
import team.creative.creativecore.client.render.GuiRenderHelper;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.controls.inventory.GuiSlot;
import team.creative.creativecore.common.gui.manager.GuiManager;
import team.creative.creativecore.common.util.math.geo.Rect;

public class GuiManagerItem
extends GuiManager {
    private ItemStack hand = ItemStack.f_41583_;
    private boolean drag;
    private boolean rightClick;
    private List<GuiSlot> dragged;
    private List<Integer> stackSizes;
    private boolean handChanged;
    public SlotAccess handAccess = new SlotAccess(){

        public ItemStack m_142196_() {
            return GuiManagerItem.this.getHand();
        }

        public boolean m_142104_(ItemStack hand) {
            GuiManagerItem.this.setHand(hand);
            return true;
        }
    };

    public static int freeSpace(Slot slot, ItemStack hand) {
        if (slot.m_5857_(hand) && AbstractContainerMenu.m_38899_((Slot)slot, (ItemStack)hand, (boolean)true)) {
            int stackSize = slot.m_5866_(hand);
            if (slot.m_6657_()) {
                stackSize -= slot.m_7993_().m_41613_();
            }
            return stackSize;
        }
        return -1;
    }

    public GuiManagerItem(GuiLayer layer) {
        super(layer);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderOverlay(GuiGraphics graphics, GuiChildControl control, Rect rect, int mouseX, int mouseY) {
        ItemStack stack = this.hand;
        int count = stack.m_41613_();
        if (this.drag) {
            int used = 0;
            int countPerSlot = Math.max(1, Mth.m_14143_((float)((float)this.hand.m_41613_() / (float)this.stackSizes.size())));
            if (this.rightClick) {
                countPerSlot = 1;
            }
            for (int i = 0; i < this.stackSizes.size(); ++i) {
                used += Math.min(countPerSlot, this.stackSizes.get(i));
            }
            int left = this.hand.m_41613_() - used;
            count = Math.max(0, left);
        }
        if (!(stack.m_41619_() || this.drag && !this.rightClick && this.dragged.size() <= 1)) {
            PoseStack pose = graphics.m_280168_();
            pose.m_85836_();
            RenderSystem.disableScissor();
            pose.m_252880_((float)(mouseX - 8), (float)(mouseY - 8), 200.0f);
            GuiRenderHelper.drawItemStack(pose, stack, 1.0f);
            GuiRenderHelper.drawItemStackDecorations(pose, stack, count);
            pose.m_85849_();
        }
    }

    @Override
    public void tick() {
        if (this.handChanged) {
            this.handChanged = false;
            if (!this.layer.isClient()) {
                CreativeCoreGuiRegistry.HAND.send(this.layer, this.hand.m_41739_(new CompoundTag()));
            }
        }
        super.tick();
    }

    @Override
    public void closed() {
        if (!(this.layer.isClient() || this.hand.m_41619_() || this.layer.getPlayer().m_36356_(this.hand))) {
            this.layer.getPlayer().m_36176_(this.hand, false);
        }
        super.closed();
    }

    @Override
    public void mouseClickedOutside(double x, double y) {
        if (!this.hand.m_41619_()) {
            CreativeCoreGuiRegistry.DROP_HAND.send(this.layer, EndTag.f_128534_);
        }
    }

    @Override
    public void mouseReleased(double x, double y, int button) {
        if (this.isDragged() && this.rightClick == (button == 1)) {
            this.endDrag();
        }
    }

    public void startDrag(GuiSlot slot, boolean rightClick, int stackSize) {
        this.drag = true;
        this.dragged = new ArrayList<GuiSlot>();
        this.dragged.add(slot);
        this.rightClick = rightClick;
        this.stackSizes = new ArrayList<Integer>();
        this.stackSizes.add(stackSize);
        slot.draggedIndex = 0;
    }

    public void addToDrag(GuiSlot slot) {
        int stackSize = GuiManagerItem.freeSpace(slot.slot, this.hand);
        if (stackSize > 0) {
            slot.draggedIndex = this.dragged.size();
            this.dragged.add(slot);
            this.stackSizes.add(stackSize);
        }
    }

    public void modifyDrag(GuiSlot slot) {
        this.stackSizes.set(slot.draggedIndex, GuiManagerItem.freeSpace(slot.slot, this.hand));
    }

    public void abortDrag() {
        for (GuiSlot slot : this.dragged) {
            slot.draggedIndex = -1;
        }
        this.drag = false;
        this.rightClick = false;
        this.dragged = null;
        this.stackSizes = null;
    }

    public void endDrag() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("rightClick", this.rightClick);
        HashMap<String, Integer> inventories = new HashMap<String, Integer>();
        ListTag names = new ListTag();
        int[] ids = new int[this.dragged.size() * 2];
        int i = 0;
        for (GuiSlot slot : this.dragged) {
            String inventory = slot.inventory().name();
            Integer inventoryId = (Integer)inventories.get(inventory);
            if (inventoryId == null) {
                inventoryId = inventories.size();
                inventories.put(inventory, inventoryId);
                names.add((Object)StringTag.m_129297_((String)inventory));
            }
            ids[i] = inventoryId;
            ids[i + 1] = slot.slot.m_150661_();
            i += 2;
        }
        nbt.m_128385_("ids", ids);
        nbt.m_128365_("names", (Tag)names);
        CreativeCoreGuiRegistry.SPREAD.sendAndExecute(this.layer, nbt);
        if (this.isDragged()) {
            this.abortDrag();
        }
    }

    public boolean isDragged() {
        return this.drag;
    }

    public ItemStack getHand() {
        return this.hand;
    }

    public void setHandChanged() {
        this.handChanged = true;
    }

    public void setHand(ItemStack stack) {
        if (this.isDragged()) {
            this.abortDrag();
        }
        this.hand = stack;
        this.setHandChanged();
    }

    public int additionalDragCount(int index) {
        if (index >= this.hand.m_41613_()) {
            return 0;
        }
        if (this.rightClick) {
            return 1;
        }
        return Math.max(1, Mth.m_14143_((float)(this.hand.m_41613_() / this.dragged.size())));
    }
}

