/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.event;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import team.creative.creativecore.common.gui.event.GuiEvent;

public class GuiEventManager {
    private List<GuiEventHandler> handlers = new ArrayList<GuiEventHandler>();

    public void raiseEvent(GuiEvent event) {
        for (GuiEventHandler handler : this.handlers) {
            handler.react(event);
            if (!event.isCanceled()) continue;
            return;
        }
    }

    public <T extends GuiEvent> void registerEvent(Class<T> clazz, Consumer<T> action) {
        this.handlers.add(new GuiEventHandler<T>(clazz, action));
    }

    public void clear() {
        this.handlers.clear();
    }

    public static class GuiEventHandler<T extends GuiEvent> {
        private final Class<T> clazz;
        private final Consumer<T> action;

        public GuiEventHandler(Class<T> clazz, Consumer<T> action) {
            this.clazz = clazz;
            this.action = action;
        }

        public void react(GuiEvent event) {
            if (this.clazz.isInstance(event)) {
                this.action.accept(event);
            }
        }
    }
}

