/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.render.box;

import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.BlockPos;
import team.creative.creativecore.client.render.VertexFormatUtils;
import team.creative.creativecore.client.render.box.RenderBox;
import team.creative.creativecore.common.util.math.base.Facing;

public class QuadGeneratorContext {
    public RenderBox box;
    public Facing facing;
    public int color;
    public VertexFormat format;
    public int uvOffset;
    public BlockPos offset;
    public boolean shouldOverrideColor;
    public BakedQuad quad;
    public boolean scaleAndOffset;
    public float offsetX;
    public float offsetY;
    public float offsetZ;
    public float scaleX;
    public float scaleY;
    public float scaleZ;
    public float minX;
    public float minY;
    public float minZ;
    public float maxX;
    public float maxY;
    public float maxZ;
    public float sizeX;
    public float sizeY;
    public float sizeZ;
    public boolean uvInverted;
    public float sizeU;
    public float sizeV;

    public void set(VertexFormat format, RenderBox box, Facing facing, int color) {
        this.color = color;
        this.format = format;
        this.facing = facing;
        this.uvOffset = VertexFormatUtils.blockUvOffset() / 4;
        this.box = box;
        this.scaleAndOffset = box.scaleAndOffsetQuads(facing);
        if (this.scaleAndOffset) {
            if (box.onlyScaleOnceNoOffset(facing)) {
                this.offsetZ = 0.0f;
                this.offsetY = 0.0f;
                this.offsetX = 0.0f;
                this.scaleY = this.scaleZ = box.getOverallScale(facing);
                this.scaleX = this.scaleZ;
            } else {
                this.offsetX = box.getOffsetX();
                this.offsetY = box.getOffsetY();
                this.offsetZ = box.getOffsetZ();
                this.scaleX = box.getScaleX();
                this.scaleY = box.getScaleY();
                this.scaleZ = box.getScaleZ();
            }
        } else {
            this.offsetZ = 0.0f;
            this.offsetY = 0.0f;
            this.offsetX = 0.0f;
            this.scaleZ = 0.0f;
            this.scaleY = 0.0f;
            this.scaleX = 0.0f;
        }
    }

    public void setQuad(BakedQuad quad, boolean overrideTint, int defaultColor) {
        this.quad = quad;
        this.shouldOverrideColor = overrideTint && (defaultColor == -1 || quad.m_111304_()) && this.color != -1;
    }

    public void setBounds(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
        this.sizeX = this.maxX - this.minX;
        this.sizeY = this.maxY - this.minY;
        this.sizeZ = this.maxZ - this.minZ;
    }

    public boolean hasBounds() {
        switch (this.facing.axis) {
            case X: {
                return this.minY != 0.0f || this.maxY != 1.0f || this.minZ != 0.0f || this.maxZ != 1.0f;
            }
            case Y: {
                return this.minX != 0.0f || this.maxX != 1.0f || this.minZ != 0.0f || this.maxZ != 1.0f;
            }
            case Z: {
                return this.minX != 0.0f || this.maxX != 1.0f || this.minY != 0.0f || this.maxY != 1.0f;
            }
        }
        return false;
    }

    public void clear() {
        this.box = null;
        this.facing = null;
        this.format = null;
        this.quad = null;
    }
}

