/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.chipped.common.compat.jei;

import earth.terrarium.chipped.common.compat.jei.ChippedRecipeCategory;
import earth.terrarium.chipped.common.recipe.ChippedRecipe;
import earth.terrarium.chipped.common.registry.ModBlocks;
import earth.terrarium.chipped.common.registry.ModRecipeTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static final ResourceLocation UID = new ResourceLocation("chipped", "chipped");

    private static List<ChippedRecipeCategory.FlattenedRecipe> flatten(Collection<ChippedRecipe> recipes) {
        ArrayList<ChippedRecipeCategory.FlattenedRecipe> flattenedRecipes = new ArrayList<ChippedRecipeCategory.FlattenedRecipe>();
        for (ChippedRecipe recipe : recipes) {
            for (HolderSet<Item> holderSet : recipe.tags()) {
                List<Item> items = holderSet.m_203614_().filter(Holder::m_203633_).map(Holder::m_203334_).toList();
                Ingredient ingredient = Ingredient.m_43921_(items.stream().map(ItemStack::new));
                for (Item item : items) {
                    flattenedRecipes.add(new ChippedRecipeCategory.FlattenedRecipe(ingredient, new ItemStack((ItemLike)item)));
                }
            }
        }
        return flattenedRecipes;
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper helper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new ChippedRecipeCategory(((Block)ModBlocks.BOTANIST_WORKBENCH.get()).m_5456_(), ChippedRecipeCategory.BOTANIST_WORKBENCH_RECIPE, helper), new ChippedRecipeCategory(((Block)ModBlocks.GLASSBLOWER.get()).m_5456_(), ChippedRecipeCategory.GLASSBLOWER_RECIPE, helper), new ChippedRecipeCategory(((Block)ModBlocks.CARPENTERS_TABLE.get()).m_5456_(), ChippedRecipeCategory.CARPENTERS_TABLE_RECIPE, helper), new ChippedRecipeCategory(((Block)ModBlocks.LOOM_TABLE.get()).m_5456_(), ChippedRecipeCategory.LOOM_TABLE_RECIPE, helper), new ChippedRecipeCategory(((Block)ModBlocks.MASON_TABLE.get()).m_5456_(), ChippedRecipeCategory.MASON_TABLE_RECIPE, helper), new ChippedRecipeCategory(((Block)ModBlocks.ALCHEMY_BENCH.get()).m_5456_(), ChippedRecipeCategory.ALCHEMY_BENCH_RECIPE, helper), new ChippedRecipeCategory(((Block)ModBlocks.TINKERING_TABLE.get()).m_5456_(), ChippedRecipeCategory.TINKERING_TABLE_RECIPE, helper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = Minecraft.m_91087_().f_91073_.m_7465_();
        registration.addRecipes(ChippedRecipeCategory.BOTANIST_WORKBENCH_RECIPE, JEIPlugin.flatten(recipeManager.m_44013_(ModRecipeTypes.BOTANIST_WORKBENCH_TYPE.get())));
        registration.addRecipes(ChippedRecipeCategory.GLASSBLOWER_RECIPE, JEIPlugin.flatten(recipeManager.m_44013_(ModRecipeTypes.GLASSBLOWER_TYPE.get())));
        registration.addRecipes(ChippedRecipeCategory.CARPENTERS_TABLE_RECIPE, JEIPlugin.flatten(recipeManager.m_44013_(ModRecipeTypes.CARPENTERS_TABLE_TYPE.get())));
        registration.addRecipes(ChippedRecipeCategory.LOOM_TABLE_RECIPE, JEIPlugin.flatten(recipeManager.m_44013_(ModRecipeTypes.LOOM_TABLE_TYPE.get())));
        registration.addRecipes(ChippedRecipeCategory.MASON_TABLE_RECIPE, JEIPlugin.flatten(recipeManager.m_44013_(ModRecipeTypes.MASON_TABLE_TYPE.get())));
        registration.addRecipes(ChippedRecipeCategory.ALCHEMY_BENCH_RECIPE, JEIPlugin.flatten(recipeManager.m_44013_(ModRecipeTypes.ALCHEMY_BENCH_TYPE.get())));
        registration.addRecipes(ChippedRecipeCategory.TINKERING_TABLE_RECIPE, JEIPlugin.flatten(recipeManager.m_44013_(ModRecipeTypes.TINKERING_TABLE_TYPE.get())));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.BOTANIST_WORKBENCH.get()), new RecipeType[]{ChippedRecipeCategory.BOTANIST_WORKBENCH_RECIPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.GLASSBLOWER.get()), new RecipeType[]{ChippedRecipeCategory.GLASSBLOWER_RECIPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.CARPENTERS_TABLE.get()), new RecipeType[]{ChippedRecipeCategory.CARPENTERS_TABLE_RECIPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.LOOM_TABLE.get()), new RecipeType[]{ChippedRecipeCategory.LOOM_TABLE_RECIPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.MASON_TABLE.get()), new RecipeType[]{ChippedRecipeCategory.MASON_TABLE_RECIPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.ALCHEMY_BENCH.get()), new RecipeType[]{ChippedRecipeCategory.ALCHEMY_BENCH_RECIPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.TINKERING_TABLE.get()), new RecipeType[]{ChippedRecipeCategory.TINKERING_TABLE_RECIPE});
    }
}

