/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.chipped.common.block;

import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CauldronBlock;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
public class SpecialPointedDripstoneBlock
extends Block
implements Fallable,
SimpleWaterloggedBlock {
    public static final DirectionProperty TIP_DIRECTION = BlockStateProperties.f_155997_;
    public static final EnumProperty<DripstoneThickness> THICKNESS = BlockStateProperties.f_155998_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape TIP_MERGE_SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape TIP_SHAPE_UP = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    private static final VoxelShape TIP_SHAPE_DOWN = Block.m_49796_((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape FRUSTUM_SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape MIDDLE_SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape BASE_SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape REQUIRED_SPACE_TO_DRIP_THROUGH_NON_SOLID_BLOCK = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);

    public SpecialPointedDripstoneBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)TIP_DIRECTION, (Comparable)Direction.UP)).m_61124_(THICKNESS, (Comparable)DripstoneThickness.TIP)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TIP_DIRECTION, THICKNESS, WATERLOGGED});
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return SpecialPointedDripstoneBlock.isValidPointedDripstonePlacement(level, pos, (Direction)state.m_61143_((Property)TIP_DIRECTION));
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (direction != Direction.UP && direction != Direction.DOWN) {
            return state;
        }
        Direction direction2 = (Direction)state.m_61143_((Property)TIP_DIRECTION);
        if (direction2 == Direction.DOWN && level.m_183326_().m_183582_(currentPos, (Object)this)) {
            return state;
        }
        if (direction == direction2.m_122424_() && !this.m_7898_(state, (LevelReader)level, currentPos)) {
            if (direction2 == Direction.DOWN) {
                level.m_186460_(currentPos, (Block)this, 2);
            } else {
                level.m_186460_(currentPos, (Block)this, 1);
            }
            return state;
        }
        boolean bl = state.m_61143_(THICKNESS) == DripstoneThickness.TIP_MERGE;
        DripstoneThickness dripstoneThickness = SpecialPointedDripstoneBlock.calculateDripstoneThickness((LevelReader)level, currentPos, direction2, bl);
        return (BlockState)state.m_61124_(THICKNESS, (Comparable)dripstoneThickness);
    }

    public void m_5581_(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        BlockPos blockPos = hit.m_82425_();
        if (!level.f_46443_ && projectile.m_142265_(level, blockPos) && projectile instanceof ThrownTrident && projectile.m_20184_().m_82553_() > 0.6) {
            level.m_46961_(blockPos, true);
        }
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (state.m_61143_((Property)TIP_DIRECTION) == Direction.UP && state.m_61143_(THICKNESS) == DripstoneThickness.TIP) {
            entity.m_142535_(fallDistance + 2.0f, 2.0f, level.m_269111_().m_269571_());
        } else {
            super.m_142072_(level, state, pos, entity, fallDistance);
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, Random random) {
        float f;
        if (SpecialPointedDripstoneBlock.canDrip(state) && !((f = random.nextFloat()) > 0.12f)) {
            SpecialPointedDripstoneBlock.getFluidAboveStalactite(level, pos, state).filter(fluid -> f < 0.02f || SpecialPointedDripstoneBlock.canFillCauldron(fluid)).ifPresent(fluid -> SpecialPointedDripstoneBlock.spawnDripParticle(level, pos, state, fluid));
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        if (SpecialPointedDripstoneBlock.isStalagmite(state) && !this.m_7898_(state, (LevelReader)level, pos)) {
            level.m_46961_(pos, true);
        } else {
            SpecialPointedDripstoneBlock.spawnFallingStalactite(state, level, pos);
        }
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        SpecialPointedDripstoneBlock.maybeFillCauldron(state, level, pos, random.nextFloat());
        if (random.nextFloat() < 0.011377778f && SpecialPointedDripstoneBlock.isStalactiteStartPos(state, (LevelReader)level, pos)) {
            SpecialPointedDripstoneBlock.growStalactiteOrStalagmiteIfPossible(state, level, pos, random);
        }
    }

    @VisibleForTesting
    public static void maybeFillCauldron(BlockState state, ServerLevel level, BlockPos pos, float randChance) {
        if (!(randChance > 0.17578125f && randChance > 0.05859375f || !SpecialPointedDripstoneBlock.isStalactiteStartPos(state, (LevelReader)level, pos))) {
            BlockPos blockPos2;
            BlockPos blockPos;
            float f;
            Fluid fluid = SpecialPointedDripstoneBlock.getCauldronFillFluidType((Level)level, pos);
            if (fluid == Fluids.f_76193_) {
                f = 0.17578125f;
            } else {
                if (fluid != Fluids.f_76195_) {
                    return;
                }
                f = 0.05859375f;
            }
            if (!(randChance >= f) && (blockPos = SpecialPointedDripstoneBlock.findTip(state, (LevelAccessor)level, pos, 11, false)) != null && (blockPos2 = SpecialPointedDripstoneBlock.findFillableCauldronBelowStalactiteTip((Level)level, blockPos, fluid)) != null) {
                level.m_46796_(1504, blockPos, 0);
                int i = blockPos.m_123342_() - blockPos2.m_123342_();
                int j = 50 + i;
                BlockState blockState = level.m_8055_(blockPos2);
                level.m_186460_(blockPos2, blockState.m_60734_(), j);
            }
        }
    }

    @NotNull
    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction;
        BlockPos blockPos;
        Level levelAccessor = context.m_43725_();
        Direction direction2 = SpecialPointedDripstoneBlock.calculateTipDirection((LevelReader)levelAccessor, blockPos = context.m_8083_(), direction = context.m_151260_().m_122424_());
        if (direction2 == null) {
            return null;
        }
        boolean bl = !context.m_7078_();
        DripstoneThickness dripstoneThickness = SpecialPointedDripstoneBlock.calculateDripstoneThickness((LevelReader)levelAccessor, blockPos, direction2, bl);
        return dripstoneThickness == null ? null : (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)TIP_DIRECTION, (Comparable)direction2)).m_61124_(THICKNESS, (Comparable)dripstoneThickness)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelAccessor.m_6425_(blockPos).m_76152_() == Fluids.f_76193_));
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @NotNull
    public VoxelShape m_7952_(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.m_83040_();
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        DripstoneThickness dripstoneThickness = (DripstoneThickness)state.m_61143_(THICKNESS);
        VoxelShape voxelShape = dripstoneThickness == DripstoneThickness.TIP_MERGE ? TIP_MERGE_SHAPE : (dripstoneThickness == DripstoneThickness.TIP ? (state.m_61143_((Property)TIP_DIRECTION) == Direction.DOWN ? TIP_SHAPE_DOWN : TIP_SHAPE_UP) : (dripstoneThickness == DripstoneThickness.FRUSTUM ? FRUSTUM_SHAPE : (dripstoneThickness == DripstoneThickness.MIDDLE ? MIDDLE_SHAPE : BASE_SHAPE)));
        Vec3 vec3 = state.m_60824_(level, pos);
        return voxelShape.m_83216_(vec3.f_82479_, 0.0, vec3.f_82481_);
    }

    public boolean m_180643_(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull BlockBehaviour.OffsetType getOffsetType() {
        return BlockBehaviour.OffsetType.XZ;
    }

    public float m_142740_() {
        return 0.125f;
    }

    public void m_142525_(Level level, BlockPos pos, FallingBlockEntity fallingBlock) {
        if (!fallingBlock.m_20067_()) {
            level.m_46796_(1045, pos, 0);
        }
    }

    @NotNull
    public Predicate<Entity> getHurtsEntitySelector() {
        return EntitySelector.f_20406_.and(EntitySelector.f_20403_);
    }

    private static void spawnFallingStalactite(BlockState state, ServerLevel level, BlockPos pos) {
        BlockPos.MutableBlockPos mutableBlockPos = pos.m_122032_();
        BlockState blockState = state;
        while (SpecialPointedDripstoneBlock.isStalactite(blockState)) {
            FallingBlockEntity fallingBlockEntity = FallingBlockEntity.m_201971_((Level)level, (BlockPos)mutableBlockPos, (BlockState)blockState);
            if (SpecialPointedDripstoneBlock.isTip(blockState, true)) {
                int i = Math.max(1 + pos.m_123342_() - mutableBlockPos.m_123342_(), 6);
                float f = i;
                fallingBlockEntity.m_149656_(f, 40);
                break;
            }
            mutableBlockPos.m_122173_(Direction.DOWN);
            blockState = level.m_8055_((BlockPos)mutableBlockPos);
        }
    }

    @VisibleForTesting
    public static void growStalactiteOrStalagmiteIfPossible(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        BlockState blockState3;
        BlockPos blockPos;
        BlockState blockState2;
        BlockState blockState = level.m_8055_(pos.m_6630_(1));
        if (SpecialPointedDripstoneBlock.canGrow(blockState, blockState2 = level.m_8055_(pos.m_6630_(2))) && (blockPos = SpecialPointedDripstoneBlock.findTip(state, (LevelAccessor)level, pos, 7, false)) != null && SpecialPointedDripstoneBlock.canDrip(blockState3 = level.m_8055_(blockPos)) && SpecialPointedDripstoneBlock.canTipGrow(blockState3, level, blockPos)) {
            if (random.nextBoolean()) {
                SpecialPointedDripstoneBlock.grow(level, blockPos, Direction.DOWN);
            } else {
                SpecialPointedDripstoneBlock.growStalagmiteBelow(level, blockPos);
            }
        }
    }

    private static void growStalagmiteBelow(ServerLevel level, BlockPos pos) {
        BlockPos.MutableBlockPos mutableBlockPos = pos.m_122032_();
        for (int i = 0; i < 10; ++i) {
            mutableBlockPos.m_122173_(Direction.DOWN);
            BlockState blockState = level.m_8055_((BlockPos)mutableBlockPos);
            if (!blockState.m_60819_().m_76178_()) {
                return;
            }
            if (SpecialPointedDripstoneBlock.isUnmergedTipWithDirection(blockState, Direction.UP) && SpecialPointedDripstoneBlock.canTipGrow(blockState, level, (BlockPos)mutableBlockPos)) {
                SpecialPointedDripstoneBlock.grow(level, (BlockPos)mutableBlockPos, Direction.UP);
                return;
            }
            if (SpecialPointedDripstoneBlock.isValidPointedDripstonePlacement((LevelReader)level, (BlockPos)mutableBlockPos, Direction.UP) && !level.m_46801_(mutableBlockPos.m_7495_())) {
                SpecialPointedDripstoneBlock.grow(level, mutableBlockPos.m_7495_(), Direction.UP);
                return;
            }
            if (SpecialPointedDripstoneBlock.canDripThrough((BlockGetter)level, (BlockPos)mutableBlockPos, blockState)) continue;
            return;
        }
    }

    private static void grow(ServerLevel server, BlockPos pos, Direction direction) {
        BlockPos blockPos = pos.m_121945_(direction);
        BlockState blockState = server.m_8055_(blockPos);
        if (SpecialPointedDripstoneBlock.isUnmergedTipWithDirection(blockState, direction.m_122424_())) {
            SpecialPointedDripstoneBlock.createMergedTips(blockState, (LevelAccessor)server, blockPos);
        } else if (blockState.m_60795_() || blockState.m_60713_(Blocks.f_49990_)) {
            SpecialPointedDripstoneBlock.createDripstone((LevelAccessor)server, blockPos, direction, DripstoneThickness.TIP);
        }
    }

    private static void createDripstone(LevelAccessor level, BlockPos pos, Direction direction, DripstoneThickness thickness) {
        Block block = level.m_8055_(pos).m_60734_();
        if (block instanceof SpecialPointedDripstoneBlock) {
            SpecialPointedDripstoneBlock block2 = (SpecialPointedDripstoneBlock)block;
            BlockState blockState = (BlockState)((BlockState)((BlockState)block2.m_49966_().m_61124_((Property)TIP_DIRECTION, (Comparable)direction)).m_61124_(THICKNESS, (Comparable)thickness)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(pos).m_76152_() == Fluids.f_76193_));
            level.m_7731_(pos, blockState, 3);
        }
    }

    private static void createMergedTips(BlockState state, LevelAccessor level, BlockPos pos) {
        BlockPos blockPos2;
        BlockPos blockPos;
        if (state.m_61143_((Property)TIP_DIRECTION) == Direction.UP) {
            blockPos = pos;
            blockPos2 = pos.m_7494_();
        } else {
            blockPos2 = pos;
            blockPos = pos.m_7495_();
        }
        SpecialPointedDripstoneBlock.createDripstone(level, blockPos2, Direction.DOWN, DripstoneThickness.TIP_MERGE);
        SpecialPointedDripstoneBlock.createDripstone(level, blockPos, Direction.UP, DripstoneThickness.TIP_MERGE);
    }

    private static void spawnDripParticle(Level level, BlockPos pos, BlockState state, Fluid fluid) {
        Vec3 vec3 = state.m_60824_((BlockGetter)level, pos);
        double e = (double)pos.m_123341_() + 0.5 + vec3.f_82479_;
        double f = (double)((float)(pos.m_123342_() + 1) - 0.6875f) - 0.0625;
        double g = (double)pos.m_123343_() + 0.5 + vec3.f_82481_;
        Fluid fluid2 = SpecialPointedDripstoneBlock.getDripFluid(level, fluid);
        SimpleParticleType particleOptions = fluid2.m_205067_(FluidTags.f_13132_) ? ParticleTypes.f_175822_ : ParticleTypes.f_175824_;
        level.m_7106_((ParticleOptions)particleOptions, e, f, g, 0.0, 0.0, 0.0);
    }

    @Nullable
    private static BlockPos findTip(BlockState state, LevelAccessor level, BlockPos pos, int maxIterations, boolean isTipMerge) {
        if (SpecialPointedDripstoneBlock.isTip(state, isTipMerge)) {
            return pos;
        }
        Direction direction = (Direction)state.m_61143_((Property)TIP_DIRECTION);
        BiPredicate<BlockPos, BlockState> biPredicate = (blockPos, blockState) -> blockState.m_60734_() instanceof SpecialPointedDripstoneBlock && blockState.m_61143_((Property)TIP_DIRECTION) == direction;
        return SpecialPointedDripstoneBlock.findBlockVertical(level, pos, direction.m_122421_(), biPredicate, blockState -> SpecialPointedDripstoneBlock.isTip(blockState, isTipMerge), maxIterations).orElse(null);
    }

    @Nullable
    private static Direction calculateTipDirection(LevelReader level, BlockPos pos, Direction dir) {
        Direction direction;
        if (SpecialPointedDripstoneBlock.isValidPointedDripstonePlacement(level, pos, dir)) {
            direction = dir;
        } else {
            if (!SpecialPointedDripstoneBlock.isValidPointedDripstonePlacement(level, pos, dir.m_122424_())) {
                return null;
            }
            direction = dir.m_122424_();
        }
        return direction;
    }

    private static DripstoneThickness calculateDripstoneThickness(LevelReader level, BlockPos pos, Direction dir, boolean isTipMerge) {
        Direction direction = dir.m_122424_();
        BlockState blockState = level.m_8055_(pos.m_121945_(dir));
        if (SpecialPointedDripstoneBlock.isPointedDripstoneWithDirection(blockState, direction)) {
            return !isTipMerge && blockState.m_61143_(THICKNESS) != DripstoneThickness.TIP_MERGE ? DripstoneThickness.TIP : DripstoneThickness.TIP_MERGE;
        }
        if (!SpecialPointedDripstoneBlock.isPointedDripstoneWithDirection(blockState, dir)) {
            return DripstoneThickness.TIP;
        }
        DripstoneThickness dripstoneThickness = (DripstoneThickness)blockState.m_61143_(THICKNESS);
        if (dripstoneThickness != DripstoneThickness.TIP && dripstoneThickness != DripstoneThickness.TIP_MERGE) {
            BlockState blockState2 = level.m_8055_(pos.m_121945_(direction));
            return !SpecialPointedDripstoneBlock.isPointedDripstoneWithDirection(blockState2, dir) ? DripstoneThickness.BASE : DripstoneThickness.MIDDLE;
        }
        return DripstoneThickness.FRUSTUM;
    }

    public static boolean canDrip(BlockState state) {
        return SpecialPointedDripstoneBlock.isStalactite(state) && state.m_61143_(THICKNESS) == DripstoneThickness.TIP && (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    private static boolean canTipGrow(BlockState state, ServerLevel level, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)TIP_DIRECTION);
        BlockPos blockPos = pos.m_121945_(direction);
        BlockState blockState = level.m_8055_(blockPos);
        if (!blockState.m_60819_().m_76178_()) {
            return false;
        }
        return blockState.m_60795_() || SpecialPointedDripstoneBlock.isUnmergedTipWithDirection(blockState, direction.m_122424_());
    }

    private static Optional<BlockPos> findRootBlock(Level level, BlockPos pos, BlockState state, int maxIterations) {
        Direction direction = (Direction)state.m_61143_((Property)TIP_DIRECTION);
        BiPredicate<BlockPos, BlockState> biPredicate = (blockPos, blockState) -> blockState.m_60734_() instanceof SpecialPointedDripstoneBlock && blockState.m_61143_((Property)TIP_DIRECTION) == direction;
        return SpecialPointedDripstoneBlock.findBlockVertical((LevelAccessor)level, pos, direction.m_122424_().m_122421_(), biPredicate, blockState -> !(blockState.m_60734_() instanceof SpecialPointedDripstoneBlock), maxIterations);
    }

    private static boolean isValidPointedDripstonePlacement(LevelReader level, BlockPos pos, Direction dir) {
        BlockPos blockPos = pos.m_121945_(dir.m_122424_());
        BlockState blockState = level.m_8055_(blockPos);
        return blockState.m_60783_((BlockGetter)level, blockPos, dir) || SpecialPointedDripstoneBlock.isPointedDripstoneWithDirection(blockState, dir);
    }

    private static boolean isTip(BlockState state, boolean isTipMerge) {
        if (!(state.m_60734_() instanceof SpecialPointedDripstoneBlock)) {
            return false;
        }
        DripstoneThickness dripstoneThickness = (DripstoneThickness)state.m_61143_(THICKNESS);
        return dripstoneThickness == DripstoneThickness.TIP || isTipMerge && dripstoneThickness == DripstoneThickness.TIP_MERGE;
    }

    private static boolean isUnmergedTipWithDirection(BlockState state, Direction dir) {
        return SpecialPointedDripstoneBlock.isTip(state, false) && state.m_61143_((Property)TIP_DIRECTION) == dir;
    }

    private static boolean isStalactite(BlockState state) {
        return SpecialPointedDripstoneBlock.isPointedDripstoneWithDirection(state, Direction.DOWN);
    }

    private static boolean isStalagmite(BlockState state) {
        return SpecialPointedDripstoneBlock.isPointedDripstoneWithDirection(state, Direction.UP);
    }

    private static boolean isStalactiteStartPos(BlockState state, LevelReader level, BlockPos pos) {
        return SpecialPointedDripstoneBlock.isStalactite(state) && !(level.m_8055_(pos.m_7494_()).m_60734_() instanceof SpecialPointedDripstoneBlock);
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    private static boolean isPointedDripstoneWithDirection(BlockState state, Direction dir) {
        return state.m_60734_() instanceof SpecialPointedDripstoneBlock && state.m_61143_((Property)TIP_DIRECTION) == dir;
    }

    @Nullable
    private static BlockPos findFillableCauldronBelowStalactiteTip(Level level, BlockPos pos, Fluid fluid) {
        Predicate<BlockState> predicate = blockState -> blockState.m_60734_() instanceof CauldronBlock;
        BiPredicate<BlockPos, BlockState> biPredicate = (blockPos, blockState) -> SpecialPointedDripstoneBlock.canDripThrough((BlockGetter)level, blockPos, blockState);
        return SpecialPointedDripstoneBlock.findBlockVertical((LevelAccessor)level, pos, Direction.DOWN.m_122421_(), biPredicate, predicate, 11).orElse(null);
    }

    public static Fluid getCauldronFillFluidType(Level level, BlockPos pos) {
        return SpecialPointedDripstoneBlock.getFluidAboveStalactite(level, pos, level.m_8055_(pos)).filter(SpecialPointedDripstoneBlock::canFillCauldron).orElse(Fluids.f_76191_);
    }

    private static Optional<Fluid> getFluidAboveStalactite(Level level, BlockPos pos, BlockState state) {
        return !SpecialPointedDripstoneBlock.isStalactite(state) ? Optional.empty() : SpecialPointedDripstoneBlock.findRootBlock(level, pos, state, 11).map(blockPos -> level.m_6425_(blockPos.m_7494_()).m_76152_());
    }

    private static boolean canFillCauldron(Fluid fluid) {
        return fluid == Fluids.f_76195_ || fluid == Fluids.f_76193_;
    }

    private static boolean canGrow(BlockState dripstoneState, BlockState state) {
        return dripstoneState.m_60713_(Blocks.f_152537_) && state.m_60713_(Blocks.f_49990_) && state.m_60819_().m_76170_();
    }

    private static Fluid getDripFluid(Level level, Fluid fluid) {
        if (fluid.m_6212_(Fluids.f_76191_)) {
            return level.m_6042_().f_63857_() ? Fluids.f_76195_ : Fluids.f_76193_;
        }
        return fluid;
    }

    private static Optional<BlockPos> findBlockVertical(LevelAccessor level, BlockPos pos, Direction.AxisDirection axis, BiPredicate<BlockPos, BlockState> positionalStatePredicate, Predicate<BlockState> statePredicate, int maxIterations) {
        Direction direction = Direction.m_122390_((Direction.AxisDirection)axis, (Direction.Axis)Direction.Axis.Y);
        BlockPos.MutableBlockPos mutableBlockPos = pos.m_122032_();
        for (int i = 1; i < maxIterations; ++i) {
            mutableBlockPos.m_122173_(direction);
            BlockState blockState = level.m_8055_((BlockPos)mutableBlockPos);
            if (statePredicate.test(blockState)) {
                return Optional.of(mutableBlockPos.m_7949_());
            }
            if (!level.m_151562_(mutableBlockPos.m_123342_()) && positionalStatePredicate.test((BlockPos)mutableBlockPos, blockState)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static boolean canDripThrough(BlockGetter level, BlockPos pos, BlockState state) {
        if (state.m_60795_()) {
            return true;
        }
        if (state.m_60804_(level, pos)) {
            return false;
        }
        if (!state.m_60819_().m_76178_()) {
            return false;
        }
        VoxelShape voxelShape = state.m_60812_(level, pos);
        return !Shapes.m_83157_((VoxelShape)REQUIRED_SPACE_TO_DRIP_THROUGH_NON_SOLID_BLOCK, (VoxelShape)voxelShape, (BooleanOp)BooleanOp.f_82689_);
    }
}

