/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.unit.token;

import dev.latvian.mods.unit.Unit;
import dev.latvian.mods.unit.operator.OperatorFactory;
import dev.latvian.mods.unit.operator.UnaryOperatorFactory;
import dev.latvian.mods.unit.token.CharStream;
import dev.latvian.mods.unit.token.OpResultUnitToken;
import dev.latvian.mods.unit.token.UnitInterpretException;
import dev.latvian.mods.unit.token.UnitToken;
import java.util.Stack;
import org.jetbrains.annotations.Nullable;

public enum UnitSymbol implements UnitToken
{
    COMMA(","),
    LP("("),
    RP(")"),
    HASH("#"),
    HOOK("?"),
    COLON(":"),
    SEMICOLON(";"),
    POSITIVE("+", Unit::positive),
    NEGATE("-", Unit::negate),
    ADD("+", 2, Unit::add),
    SUB("-", 2, Unit::sub),
    MUL("*", 3, Unit::mul),
    DIV("/", 3, Unit::div),
    MOD("%", 3, Unit::mod),
    POW("**", 4, Unit::pow),
    LSH("<<", 2, Unit::lsh),
    RSH(">>", 2, Unit::rsh),
    BIT_AND("&", 2, Unit::bitAnd),
    BIT_OR("|", 2, Unit::bitOr),
    XOR("^", 2, Unit::xor),
    BIT_NOT("~", Unit::bitNot),
    EQ("==", 1, Unit::eq),
    NEQ("!=", 1, Unit::neq),
    LT("<", 1, Unit::lt),
    GT(">", 1, Unit::gt),
    LTE("<=", 1, Unit::lte),
    GTE(">=", 1, Unit::gte),
    AND("&&", 1, Unit::and),
    OR("||", 1, Unit::or),
    BOOL_NOT("!", Unit::boolNot),
    SET("=", 0, Unit::set),
    ADD_SET("+=", 0, Unit::addSet),
    SUB_SET("-=", 0, Unit::subSet),
    MUL_SET("*=", 0, Unit::mulSet),
    DIV_SET("/=", 0, Unit::divSet),
    MOD_SET("%=", 0, Unit::modSet);

    public final String symbol;
    public final int precedence;
    public final OperatorFactory op;
    public final UnaryOperatorFactory unaryOp;

    @Nullable
    public static UnitSymbol read(char first, CharStream stream) {
        return switch (first) {
            case ',' -> COMMA;
            case '(' -> LP;
            case ')' -> RP;
            case '#' -> HASH;
            case '?' -> HOOK;
            case ':' -> COLON;
            case ';' -> SEMICOLON;
            case '+' -> {
                if (stream.nextIf('=')) {
                    yield ADD_SET;
                }
                yield ADD;
            }
            case '-' -> {
                if (stream.nextIf('=')) {
                    yield SUB_SET;
                }
                yield SUB;
            }
            case '*' -> {
                if (stream.nextIf('*')) {
                    yield POW;
                }
                if (stream.nextIf('=')) {
                    yield MUL_SET;
                }
                yield MUL;
            }
            case '/' -> {
                if (stream.nextIf('=')) {
                    yield DIV_SET;
                }
                yield DIV;
            }
            case '%' -> {
                if (stream.nextIf('=')) {
                    yield MOD_SET;
                }
                yield MOD;
            }
            case '^' -> XOR;
            case '~' -> BIT_NOT;
            case '&' -> {
                if (stream.nextIf('&')) {
                    yield AND;
                }
                yield BIT_AND;
            }
            case '|' -> {
                if (stream.nextIf('|')) {
                    yield OR;
                }
                yield BIT_OR;
            }
            case '!' -> {
                if (stream.nextIf('=')) {
                    yield NEQ;
                }
                yield BOOL_NOT;
            }
            case '<' -> {
                if (stream.nextIf('=')) {
                    yield LTE;
                }
                if (stream.nextIf('<')) {
                    yield LSH;
                }
                yield LT;
            }
            case '>' -> {
                if (stream.nextIf('=')) {
                    yield GTE;
                }
                if (stream.nextIf('>')) {
                    yield RSH;
                }
                yield GT;
            }
            case '=' -> {
                if (stream.nextIf('=')) {
                    yield EQ;
                }
                yield SET;
            }
            default -> null;
        };
    }

    private UnitSymbol(String s) {
        this.symbol = s;
        this.precedence = 0;
        this.op = null;
        this.unaryOp = null;
    }

    private UnitSymbol(String s, int p, OperatorFactory opUnit) {
        this.symbol = s;
        this.precedence = p;
        this.op = opUnit;
        this.unaryOp = null;
    }

    private UnitSymbol(String s, UnaryOperatorFactory unaryOpUnit) {
        this.symbol = s;
        this.precedence = 0;
        this.op = null;
        this.unaryOp = unaryOpUnit;
    }

    public String toString() {
        return this.symbol;
    }

    @Override
    public boolean nextUnaryOperator() {
        return this != RP;
    }

    @Nullable
    public UnitSymbol getUnarySymbol() {
        return switch (this) {
            case ADD -> POSITIVE;
            case SUB -> NEGATE;
            default -> null;
        };
    }

    public boolean is(UnitToken next) {
        return next == this;
    }

    @Override
    public void unstack(Stack<UnitToken> stack) {
        if (this.op != null) {
            if (stack.size() < 2) {
                throw new UnitInterpretException("Not enough elements in stack!");
            }
        } else {
            throw new UnitInterpretException("Unexpected symbol '" + this + "'!");
        }
        UnitToken right = stack.pop();
        UnitToken left = stack.pop();
        stack.push(new OpResultUnitToken(this, left, right));
    }

    public final boolean hasHigherPrecedenceThan(UnitSymbol operator) {
        return operator.precedence <= this.precedence;
    }
}

