/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.imitator;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.jeicompat.imitator.JEIFurnaceVariantCategory;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public abstract class JEIAbstractCookingCategory<T extends AbstractCookingRecipe>
extends JEIFurnaceVariantCategory<T> {
    private final IDrawable background;
    private final int regularCookTime;
    private final IDrawable icon;
    private final Component localizedName;
    private final LoadingCache<Integer, IDrawableAnimated> cachedArrows;

    public JEIAbstractCookingCategory(final IGuiHelper guiHelper, Block icon, String translationKey, int regularCookTime) {
        super(guiHelper);
        this.background = guiHelper.createDrawable(new ResourceLocation("jei:textures/gui/gui_vanilla.png"), 0, 114, 82, 54);
        this.regularCookTime = regularCookTime;
        this.icon = guiHelper.createDrawableIngredient(VanillaTypes.ITEM_STACK, new ItemStack((ItemLike)icon));
        this.localizedName = Component.m_237115_((String)translationKey);
        this.cachedArrows = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer cookTime) {
                return guiHelper.drawableBuilder(new ResourceLocation("jei:textures/gui/gui_vanilla.png"), 82, 128, 24, 17).buildAnimated(cookTime, IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
    }

    protected IDrawableAnimated getArrow(T recipe) {
        int cookTime = recipe.m_43753_();
        if (cookTime <= 0) {
            cookTime = this.regularCookTime;
        }
        return (IDrawableAnimated)this.cachedArrows.getUnchecked((Object)cookTime);
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    public void draw(T recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        this.animatedFlame.draw(graphics, 1, 20);
        IDrawableAnimated arrow = this.getArrow(recipe);
        arrow.draw(graphics, 24, 18);
        this.drawExperience(recipe, graphics, 0);
        this.drawCookTime(recipe, graphics, 45);
    }

    protected void drawExperience(T recipe, GuiGraphics graphics, int y) {
        float experience = recipe.m_43750_();
        if (experience > 0.0f) {
            MutableComponent experienceString = Component.m_237110_((String)"gui.jei.category.smelting.experience", (Object[])new Object[]{Float.valueOf(experience)});
            Minecraft minecraft = Minecraft.m_91087_();
            Font fontRenderer = minecraft.f_91062_;
            int stringWidth = fontRenderer.m_92852_((FormattedText)experienceString);
            graphics.m_280614_(fontRenderer, (Component)experienceString, this.background.getWidth() - stringWidth, y, -8355712, false);
        }
    }

    protected void drawCookTime(T recipe, GuiGraphics graphics, int y) {
        int cookTime = recipe.m_43753_();
        if (cookTime > 0) {
            int cookTimeSeconds = cookTime / 20;
            MutableComponent timeString = Component.m_237110_((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds});
            Minecraft minecraft = Minecraft.m_91087_();
            Font fontRenderer = minecraft.f_91062_;
            int stringWidth = fontRenderer.m_92852_((FormattedText)timeString);
            graphics.m_280614_(fontRenderer, (Component)timeString, this.background.getWidth() - stringWidth, y, -8355712, false);
        }
    }

    @Override
    public Component getTitle() {
        return this.localizedName;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addIngredients((Ingredient)recipe.m_7527_().get(0));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 61, 19).addItemStack(recipe.m_8043_(BasicDisplay.registryAccess()));
    }

    @Override
    public boolean isHandled(T recipe) {
        return !recipe.m_5598_();
    }
}

