/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.compatibility;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import net.bettercombat.Platform;
import net.bettercombat.api.client.AttackRangeExtensions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class PehkuiHelper {
    public static ResourceLocation scaleId = new ResourceLocation("pehkui", "entity_reach");
    private static final Method GET_SCALE_DATA;
    private static final Method GET_SCALE;
    private static final Map<ResourceLocation, Object> SCALE_TYPES;

    public static float getScale(Entity entity) {
        return PehkuiHelper.getScale(entity, scaleId, 1.0f);
    }

    public static float getScale(Entity entity, ResourceLocation scaleId, float tickDelta) {
        if (GET_SCALE_DATA != null && GET_SCALE != null && SCALE_TYPES != null) {
            try {
                return ((Float)GET_SCALE.invoke(GET_SCALE_DATA.invoke(SCALE_TYPES.get(scaleId), entity), Float.valueOf(tickDelta))).floatValue();
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
                return 1.0f;
            }
        }
        return 1.0f;
    }

    static {
        Method getScaleDataMethod = null;
        Method getScaleMethod = null;
        Map scaleTypes = null;
        if (Platform.isModLoaded("pehkui")) {
            try {
                Class<?> scaleTypeClass = Class.forName("virtuoel.pehkui.api.ScaleType");
                Class<?> scaleDataClass = Class.forName("virtuoel.pehkui.api.ScaleData");
                Class<?> scaleRegistriesClass = Class.forName("virtuoel.pehkui.api.ScaleRegistries");
                Field scaleTypesField = scaleRegistriesClass.getField("SCALE_TYPES");
                getScaleDataMethod = scaleTypeClass.getMethod("getScaleData", Entity.class);
                getScaleMethod = scaleDataClass.getMethod("getScale", Float.TYPE);
                scaleTypes = (Map)scaleTypesField.get(null);
                AttackRangeExtensions.register(context -> new AttackRangeExtensions.Modifier(PehkuiHelper.getScale((Entity)context.player()), AttackRangeExtensions.Operation.MULTIPLY));
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException e) {
                getScaleDataMethod = null;
                getScaleMethod = null;
                scaleTypes = null;
            }
        }
        GET_SCALE_DATA = getScaleDataMethod;
        GET_SCALE = getScaleMethod;
        SCALE_TYPES = scaleTypes;
    }
}

