/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.common.item;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.lwjgl.system.NonnullDefault;
import xerca.xercapaint.client.ClientStuff;
import xerca.xercapaint.common.CanvasType;
import xerca.xercapaint.common.entity.EntityCanvas;
import xerca.xercapaint.common.item.RenderProp;

@NonnullDefault
public class ItemCanvas
extends Item {
    private final CanvasType canvasType;

    ItemCanvas(CanvasType canvasType) {
        super(new Item.Properties().m_41487_(1));
        this.canvasType = canvasType;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, @Nonnull InteractionHand hand) {
        if (worldIn.f_46443_) {
            ClientStuff.showCanvasGui(playerIn);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)playerIn.m_21120_(hand));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos blockpos = context.m_8083_();
        Direction direction = context.m_43719_();
        BlockPos pos = blockpos.m_121945_(direction);
        Player player = context.m_43723_();
        ItemStack itemstack = context.m_43722_();
        if (player != null) {
            if (!this.mayPlace(player, direction, itemstack, pos)) {
                if (context.m_43725_().f_46443_) {
                    ClientStuff.showCanvasGui(player);
                }
            } else {
                EntityCanvas entityCanvas;
                Level world = context.m_43725_();
                CompoundTag tag = itemstack.m_41783_();
                if (tag == null || !tag.m_128441_("pixels") || !tag.m_128441_("name")) {
                    if (context.m_43725_().f_46443_) {
                        ClientStuff.showCanvasGui(player);
                    }
                    return InteractionResult.SUCCESS;
                }
                int rotation = 0;
                if (direction.m_122434_() == Direction.Axis.Y) {
                    double xDiff = (double)blockpos.m_123341_() - player.m_20185_();
                    double zDiff = (double)blockpos.m_123343_() - player.m_20189_();
                    if (Math.abs(xDiff) > Math.abs(zDiff)) {
                        rotation = xDiff > 0.0 ? 1 : 3;
                    } else if (zDiff > 0.0) {
                        rotation = 2;
                    }
                    if (direction == Direction.DOWN && Math.abs(xDiff) < Math.abs(zDiff)) {
                        rotation += 2;
                    }
                }
                if (!world.f_46443_ && (entityCanvas = new EntityCanvas(world, tag, pos, direction, this.canvasType, rotation)).m_7088_()) {
                    entityCanvas.m_7084_();
                    world.m_7967_((Entity)entityCanvas);
                    itemstack.m_41774_(1);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public static boolean hasTitle(@Nonnull ItemStack stack) {
        CompoundTag tag;
        if (stack.m_41782_() && (tag = stack.m_41783_()) != null) {
            String s = tag.m_128461_("title");
            return !StringUtil.m_14408_((String)s);
        }
        return false;
    }

    public static Component getFullLabel(@Nonnull ItemStack stack) {
        Object labelString = "";
        int generation = 0;
        Component title = ItemCanvas.getCustomTitle(stack);
        if (title != null) {
            labelString = (String)labelString + title.getString() + " ";
        }
        if (stack.m_41782_() && stack.m_41783_() != null) {
            CompoundTag tag = stack.m_41783_();
            String s = tag.m_128461_("author");
            if (!StringUtil.m_14408_((String)s)) {
                labelString = (String)labelString + Component.m_237110_((String)"canvas.byAuthor", (Object[])new Object[]{s}).getString() + " ";
            }
            generation = tag.m_128451_("generation");
        }
        MutableComponent label = Component.m_237113_((String)labelString);
        if (generation == 1) {
            label.m_130940_(ChatFormatting.YELLOW);
        } else if (generation >= 3) {
            label.m_130940_(ChatFormatting.GRAY);
        }
        return label;
    }

    @Nullable
    public static Component getCustomTitle(@Nonnull ItemStack stack) {
        String s;
        CompoundTag tag;
        if (stack.m_41782_() && (tag = stack.m_41783_()) != null && !StringUtil.m_14408_((String)(s = tag.m_128461_("title")))) {
            return Component.m_237113_((String)s);
        }
        return null;
    }

    @Nonnull
    public Component m_7626_(@Nonnull ItemStack stack) {
        Component comp = ItemCanvas.getCustomTitle(stack);
        if (comp != null) {
            return comp;
        }
        return super.m_7626_(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.m_41782_() && stack.m_41783_() != null) {
            int generation;
            CompoundTag tag = stack.m_41783_();
            String s = tag.m_128461_("author");
            if (!StringUtil.m_14408_((String)s)) {
                tooltip.add((Component)Component.m_237110_((String)"canvas.byAuthor", (Object[])new Object[]{s}));
            }
            if ((generation = tag.m_128451_("generation")) > 0) {
                tooltip.add((Component)Component.m_237115_((String)("canvas.generation." + (generation - 1))).m_130940_(ChatFormatting.GRAY));
            }
        } else {
            tooltip.add((Component)Component.m_237115_((String)"canvas.empty").m_130940_(ChatFormatting.GRAY));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_5812_(ItemStack stack) {
        CompoundTag tag;
        if (stack.m_41782_() && (tag = stack.m_41783_()) != null) {
            int generation = tag.m_128451_("generation");
            return generation > 0;
        }
        return false;
    }

    public int getWidth() {
        return CanvasType.getWidth(this.canvasType);
    }

    public int getHeight() {
        return CanvasType.getHeight(this.canvasType);
    }

    public CanvasType getCanvasType() {
        return this.canvasType;
    }

    protected boolean mayPlace(Player playerIn, Direction directionIn, ItemStack itemStackIn, BlockPos posIn) {
        if (this.canvasType == CanvasType.SMALL) {
            return Level.m_46741_((BlockPos)posIn) && playerIn.m_36204_(posIn, directionIn, itemStackIn);
        }
        return !directionIn.m_122434_().m_122478_() && playerIn.m_36204_(posIn, directionIn, itemStackIn);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(RenderProp.INSTANCE);
    }
}

