/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.client;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import xerca.xercapaint.client.ClientStuff;
import xerca.xercapaint.client.EaselCanvasLayer;
import xerca.xercapaint.client.EaselModel;
import xerca.xercapaint.common.entity.EntityEasel;
import xerca.xercapaint.common.item.ItemCanvas;

@OnlyIn(value=Dist.CLIENT)
@ParametersAreNonnullByDefault
public class RenderEntityEasel
extends EntityRenderer<EntityEasel>
implements RenderLayerParent<EntityEasel, EaselModel> {
    protected final EaselModel model;
    protected final List<RenderLayer<EntityEasel, EaselModel>> layers = Lists.newArrayList();
    public static RenderEntityEasel theInstance;
    private static final ResourceLocation woodTexture;

    RenderEntityEasel(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.model = new EaselModel(ctx.m_174023_(ClientStuff.EASEL_MAIN_LAYER));
        this.layers.add(new EaselCanvasLayer(this));
    }

    @NotNull
    public EaselModel getModel() {
        return this.model;
    }

    @NotNull
    public ResourceLocation getTextureLocation(EntityEasel entity) {
        return woodTexture;
    }

    public void render(EntityEasel entity, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        matrixStackIn.m_85836_();
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(-entityYaw));
        this.model.setupAnim(entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        matrixStackIn.m_252781_(new Quaternionf().rotationXYZ((float)Math.PI, 0.0f, 0.0f));
        matrixStackIn.m_85837_(0.0, -1.5, 0.0);
        RenderType rendertype = this.model.m_103119_(this.getTextureLocation(entity));
        VertexConsumer vertexconsumer = bufferIn.m_6299_(rendertype);
        int i = OverlayTexture.m_118093_((int)OverlayTexture.m_118088_((float)0.0f), (int)OverlayTexture.m_118096_((boolean)false));
        this.model.m_7695_(matrixStackIn, vertexconsumer, packedLightIn, i, 1.0f, 1.0f, 1.0f, 1.0f);
        this.layers.forEach(renderLayer -> renderLayer.m_6494_(matrixStackIn, bufferIn, packedLightIn, (Entity)entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f));
        matrixStackIn.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    protected boolean shouldShowName(EntityEasel easel) {
        HitResult result = Minecraft.m_91087_().f_91077_;
        if (result instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)result;
            if (Minecraft.m_91404_() && entityHitResult.m_82443_() == easel && !easel.getItem().m_41619_() && ItemCanvas.hasTitle(easel.getItem())) {
                double d0 = this.f_114476_.m_114471_((Entity)easel);
                float f = easel.m_20163_() ? 32.0f : 64.0f;
                return d0 < (double)(f * f);
            }
        }
        return false;
    }

    protected void renderNameTag(EntityEasel easel, Component component, PoseStack poseStack, MultiBufferSource bufferSource, int pPackedLight) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, -0.5, 0.0);
        super.m_7649_((Entity)easel, ItemCanvas.getFullLabel(easel.getItem()), poseStack, bufferSource, pPackedLight);
        poseStack.m_85849_();
    }

    static {
        woodTexture = new ResourceLocation("xercapaint", "textures/block/birch_long.png");
    }

    public static class RenderEntityEaselFactory
    implements EntityRendererProvider<EntityEasel> {
        @NotNull
        public EntityRenderer<EntityEasel> m_174009_(EntityRendererProvider.Context ctx) {
            theInstance = new RenderEntityEasel(ctx);
            return theInstance;
        }
    }
}

