/*
 * Decompiled with CFR 0.152.
 */
package club.someoneice.cofe_delight.common.block;

import club.someoneice.cofe_delight.common.block.BlockCap;
import club.someoneice.cofe_delight.init.BlockInit;
import club.someoneice.cofe_delight.util.BlockBean;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class BlockCoffee
extends BlockCap {
    float saturation;
    BlockBean.CAP cap;
    @Nullable
    MobEffect[] effects;
    int hunger;
    int time;
    int level;
    boolean hasSugar = false;

    public BlockCoffee(int hunger, float saturation, BlockBean.CAP cap, @Nullable MobEffect[] effects, int time, int level) {
        this.hunger = hunger;
        this.saturation = saturation;
        this.cap = cap;
        this.effects = effects;
        this.time = time;
        this.level = level;
    }

    public BlockCoffee(int hunger, float saturation, BlockBean.CAP cap) {
        this(hunger, saturation, cap, null, 0, 0);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (player.m_21120_(hand).m_150930_(Items.f_42501_) && !this.hasSugar) {
            this.hasSugar = true;
            return InteractionResult.SUCCESS;
        }
        player.m_5496_(SoundEvents.f_11970_, 1.0f, 1.0f);
        player.m_36324_().m_38707_(this.hunger, this.saturation);
        if (this.effects != null) {
            for (MobEffect effect : this.effects) {
                player.m_7292_(new MobEffectInstance(effect, this.time, this.level));
            }
        }
        if (this.hasSugar) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 600, 1));
        }
        switch (this.cap) {
            case CAP: {
                world.m_7731_(pos, ((Block)BlockInit.COFFEE_CAP.get()).m_152465_(state), 0);
                break;
            }
            case MAG: {
                world.m_7731_(pos, ((Block)BlockInit.COFFEE_MAG.get()).m_152465_(state), 0);
            }
        }
        return InteractionResult.SUCCESS;
    }
}

