/*
 * Decompiled with CFR 0.152.
 */
package com.mystchonky.tomeofblood.common.events;

import com.hollingsworth.arsnouveau.api.event.SpellCastEvent;
import com.hollingsworth.arsnouveau.api.event.SpellCostCalcEvent;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.util.ManaUtil;
import com.mystchonky.tomeofblood.client.ClientInfo;
import com.mystchonky.tomeofblood.common.registry.LivingUpgradeRegistry;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import wayoftime.bloodmagic.core.living.LivingStats;
import wayoftime.bloodmagic.core.living.LivingUpgrade;
import wayoftime.bloodmagic.core.living.LivingUtil;

@Mod.EventBusSubscriber(modid="tomeofblood")
public class EventHandler {
    @SubscribeEvent
    public static void clientTickEnd(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ++ClientInfo.ticksInGame;
        }
    }

    @SubscribeEvent
    public static void spellDiscount(SpellCostCalcEvent event) {
        Player player;
        LivingEntity livingEntity = event.context.getUnwrappedCaster();
        if (livingEntity instanceof Player && LivingUtil.hasFullSet((Player)(player = (Player)livingEntity))) {
            LivingStats stats = LivingStats.fromPlayer((Player)player);
            int level = stats.getLevel(LivingUpgradeRegistry.MANA_UPGRADE.getKey());
            double discount = (double)level * 0.05;
            event.currentCost = (int)((1.0 - discount) * (double)event.currentCost);
        }
    }

    @SubscribeEvent
    public static void awardXPForSpellCast(SpellCastEvent event) {
        Player player;
        LivingEntity livingEntity = event.context.getUnwrappedCaster();
        if (livingEntity instanceof Player && LivingUtil.hasFullSet((Player)(player = (Player)livingEntity))) {
            Spell spell = event.spell;
            SpellContext spellContext = event.context;
            int cost = spellContext.getSpell().getCost() - ManaUtil.getPlayerDiscounts((LivingEntity)spellContext.getUnwrappedCaster(), (Spell)spell, (ItemStack)spellContext.getCasterTool());
            cost = Math.max(cost, 0);
            int xpAward = cost / 100;
            LivingUtil.applyNewExperience((Player)player, (LivingUpgrade)LivingUpgradeRegistry.MANA_UPGRADE, (double)xpAward);
        }
    }
}

