/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.better_totem_of_undying.mixin.entity;

import com.cerbon.better_totem_of_undying.utils.BTUUtils;
import com.cerbon.better_totem_of_undying.utils.ILivingEntityMixin;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class}, priority=1100)
public abstract class LivingEntityMixin
extends Entity
implements ILivingEntityMixin {
    @Unique
    private long better_totem_of_undying_lastBlockPos;

    private LivingEntityMixin(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(method={"checkTotemDeathProtection"}, at={@At(value="HEAD")}, cancellable=true)
    private void better_totem_of_undying_checkTotemDeathProtection(DamageSource pDamageSource, @NotNull CallbackInfoReturnable<Boolean> cir) {
        LivingEntity livingEntity = (LivingEntity)this;
        cir.setReturnValue((Object)BTUUtils.canSaveFromDeath(livingEntity, pDamageSource));
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void better_totem_of_undying_addCustomData(@NotNull CompoundTag pCompound, CallbackInfo ci) {
        pCompound.m_128356_("BTULastBlockPos", this.better_totem_of_undying_getLastBlockPos());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void better_totem_of_undying_readCustomData(@NotNull CompoundTag pCompound, CallbackInfo ci) {
        this.better_totem_of_undying_lastBlockPos = pCompound.m_128454_("BTULastBlockPos");
    }

    @Inject(method={"baseTick"}, at={@At(value="TAIL")})
    private void better_totem_of_undying_saveEntityLastBlockPos(CallbackInfo ci) {
        if (!this.m_9236_().f_46443_) {
            Level level = this.m_9236_();
            BlockPos currentPos = this.m_20183_();
            BlockState blockBelowEntityPos = level.m_8055_(currentPos.m_7495_());
            boolean isValidBlock = blockBelowEntityPos.m_60796_((BlockGetter)level, currentPos.m_7495_());
            if (!Objects.equals(this.better_totem_of_undying_lastBlockPos, currentPos.m_121878_()) && isValidBlock) {
                this.better_totem_of_undying_lastBlockPos = currentPos.m_121878_();
            }
        }
    }

    @Override
    @Unique
    public long better_totem_of_undying_getLastBlockPos() {
        return this.better_totem_of_undying_lastBlockPos;
    }
}

