/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.simplerpc;

import com.hypherionmc.craterlib.api.event.client.CraterClientTickEvent;
import com.hypherionmc.craterlib.api.event.client.CraterSinglePlayerEvent;
import com.hypherionmc.craterlib.api.event.client.LateInitEvent;
import com.hypherionmc.craterlib.api.event.client.PlayerJoinRealmEvent;
import com.hypherionmc.craterlib.api.event.client.ScreenEvent;
import com.hypherionmc.craterlib.core.event.CraterEventBus;
import com.hypherionmc.craterlib.core.event.annot.CraterEventListener;
import me.hypherionmc.simplerpc.Utils;
import me.hypherionmc.simplerpclib.configuration.GameType;
import me.hypherionmc.simplerpclib.discord.RichPresenceCore;
import me.hypherionmc.simplerpclib.discord.RichPresenceEvents;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.LevelLoadingScreen;
import net.minecraft.client.gui.screens.ReceivingLevelScreen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.resources.ResourceLocation;

public class SimpleRPCClient {
    public static RichPresenceCore rpcCore;
    public static RichPresenceEvents rpcEvents;
    public static ResourceLocation DISCORD;

    public static void setupEvents() {
        CraterEventBus.INSTANCE.registerEventListener(SimpleRPCClient.class);
    }

    @CraterEventListener
    public static void init(LateInitEvent event) {
        rpcCore = new RichPresenceCore(new Utils(), event.getMinecraft().f_91069_.getAbsolutePath(), event.getOptions().f_92075_ == null ? "en_us" : event.getOptions().f_92075_);
        rpcEvents = rpcCore.getEvents();
    }

    @CraterEventListener
    public static void playerJoinGame(CraterSinglePlayerEvent.PlayerLogin event) {
        if (event.getPlayer().m_20148_().equals(Minecraft.m_91087_().f_91074_.m_20148_())) {
            rpcCore.setLangCode(Minecraft.m_91087_().f_91066_.f_92075_);
            rpcEvents.joinGame();
        }
    }

    @CraterEventListener
    public static void screenOpenEvent(ScreenEvent.Opening event) {
        if (event.getScreen() instanceof TitleScreen) {
            rpcCore.setLangCode(Minecraft.m_91087_().f_91066_.f_92075_);
            rpcEvents.mainMenuRPC();
        }
        if (event.getScreen() instanceof RealmsScreen) {
            rpcCore.setLangCode(Minecraft.m_91087_().f_91066_.f_92075_);
            rpcEvents.realmRPC();
        }
        if (event.getScreen() instanceof JoinMultiplayerScreen) {
            rpcCore.setLangCode(Minecraft.m_91087_().f_91066_.f_92075_);
            rpcEvents.serverListRPC();
        }
        if (event.getScreen() instanceof LevelLoadingScreen || event.getScreen() instanceof ReceivingLevelScreen) {
            rpcCore.setLangCode(Minecraft.m_91087_().f_91066_.f_92075_);
            rpcEvents.joiningGameRPC();
        }
    }

    @CraterEventListener
    public static void playerJoinRealm(PlayerJoinRealmEvent event) {
        Utils.realmsServer = event.getServer();
    }

    public static void setServerConfig(String config) {
        RichPresenceCore.setServerConfig(config);
    }

    @CraterEventListener
    public static void clientTick(CraterClientTickEvent event) {
        if (event.getLevel() != null && event.getLevel().f_46443_ && rpcEvents != null && event.getLevel().m_46467_() % 40L == 0L) {
            if (Minecraft.m_91087_().m_91294_()) {
                rpcEvents.ingameRPC(GameType.REALM);
            } else {
                rpcEvents.ingameRPC(Minecraft.m_91087_().m_91091_() ? GameType.SINGLE : GameType.MULTIPLAYER);
            }
        }
    }

    static {
        DISCORD = new ResourceLocation("simplerpc:widgets.png");
    }
}

