/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.inventory.item;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.inventory.BigInventoryHandler;
import com.buuz135.functionalstorage.item.StorageUpgradeItem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class DrawerStackItemHandler
implements IItemHandler,
INBTSerializable<CompoundTag> {
    private List<BigInventoryHandler.BigStack> storedStacks;
    private ItemStack stack;
    private FunctionalStorage.DrawerType type;
    private int multiplier;
    private boolean downgrade;
    private boolean isVoid;

    public DrawerStackItemHandler(ItemStack stack, FunctionalStorage.DrawerType drawerType) {
        this.stack = stack;
        this.storedStacks = new ArrayList<BigInventoryHandler.BigStack>();
        this.type = drawerType;
        this.multiplier = 1;
        this.downgrade = false;
        this.isVoid = false;
        for (int i = 0; i < drawerType.getSlots(); ++i) {
            this.storedStacks.add(i, new BigInventoryHandler.BigStack(ItemStack.f_41583_, 0));
        }
        if (stack.m_41782_()) {
            ItemStack itemStack;
            this.deserializeNBT(stack.m_41783_().m_128469_("Tile").m_128469_("handler"));
            for (Tag tag : stack.m_41784_().m_128469_("Tile").m_128469_("storageUpgrades").m_128437_("Items", 10)) {
                itemStack = ItemStack.m_41712_((CompoundTag)((CompoundTag)tag));
                if (itemStack.m_41720_() instanceof StorageUpgradeItem) {
                    this.multiplier = this.multiplier == 1 ? ((StorageUpgradeItem)itemStack.m_41720_()).getStorageMultiplier() : (this.multiplier *= ((StorageUpgradeItem)itemStack.m_41720_()).getStorageMultiplier());
                }
                if (!itemStack.m_41720_().equals(FunctionalStorage.STORAGE_UPGRADES.get((Object)StorageUpgradeItem.StorageTier.IRON).get())) continue;
                this.downgrade = true;
            }
            for (Tag tag : stack.m_41784_().m_128469_("Tile").m_128469_("utilityUpgrades").m_128437_("Items", 10)) {
                itemStack = ItemStack.m_41712_((CompoundTag)((CompoundTag)tag));
                if (!itemStack.m_41720_().equals(FunctionalStorage.VOID_UPGRADE.get())) continue;
                this.isVoid = true;
            }
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag compoundTag = new CompoundTag();
        CompoundTag items = new CompoundTag();
        for (int i = 0; i < this.storedStacks.size(); ++i) {
            CompoundTag bigStack = new CompoundTag();
            bigStack.m_128365_(BigInventoryHandler.STACK, (Tag)this.storedStacks.get(i).getStack().serializeNBT());
            bigStack.m_128405_(BigInventoryHandler.AMOUNT, this.storedStacks.get(i).getAmount());
            items.m_128365_("" + i, (Tag)bigStack);
        }
        compoundTag.m_128365_(BigInventoryHandler.BIG_ITEMS, (Tag)items);
        return compoundTag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        for (String allKey : nbt.m_128469_(BigInventoryHandler.BIG_ITEMS).m_128431_()) {
            this.storedStacks.get(Integer.parseInt(allKey)).setStack(ItemStack.m_41712_((CompoundTag)nbt.m_128469_(BigInventoryHandler.BIG_ITEMS).m_128469_(allKey).m_128469_(BigInventoryHandler.STACK)));
            this.storedStacks.get(Integer.parseInt(allKey)).setAmount(nbt.m_128469_(BigInventoryHandler.BIG_ITEMS).m_128469_(allKey).m_128451_(BigInventoryHandler.AMOUNT));
        }
    }

    public int getSlots() {
        return this.type.getSlots();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        BigInventoryHandler.BigStack bigStack = this.storedStacks.get(slot);
        ItemStack copied = bigStack.getStack().m_41777_();
        copied.m_41764_(bigStack.getAmount());
        return copied;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (this.isValid(slot, stack)) {
            BigInventoryHandler.BigStack bigStack = this.storedStacks.get(slot);
            int inserted = Math.min(this.getSlotLimit(slot) - bigStack.getAmount(), stack.m_41613_());
            if (!simulate) {
                bigStack.setStack(stack);
                bigStack.setAmount(Math.min(bigStack.getAmount() + inserted, this.getSlotLimit(slot)));
                this.onChange();
            }
            if (inserted == stack.m_41613_() || this.isVoid()) {
                return ItemStack.f_41583_;
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - inserted));
        }
        return stack;
    }

    private boolean isVoid() {
        return true;
    }

    private void onChange() {
        if (this.stack.m_41784_().m_128441_("Tile")) {
            this.stack.m_41784_().m_128365_("Tile", (Tag)new CompoundTag());
        }
        this.stack.m_41784_().m_128469_("Tile").m_128365_("handler", (Tag)this.serializeNBT());
    }

    private boolean isValid(int slot, @Nonnull ItemStack stack) {
        if (slot < this.type.getSlots()) {
            BigInventoryHandler.BigStack bigStack = this.storedStacks.get(slot);
            ItemStack fl = bigStack.getStack();
            return fl.m_41619_() || ItemStack.m_150942_((ItemStack)fl, (ItemStack)stack);
        }
        return false;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.f_41583_;
        }
        if (slot < this.type.getSlots()) {
            BigInventoryHandler.BigStack bigStack = this.storedStacks.get(slot);
            if (bigStack.getStack().m_41619_()) {
                return ItemStack.f_41583_;
            }
            if (bigStack.getAmount() <= amount) {
                ItemStack out = bigStack.getStack().m_41777_();
                int newAmount = bigStack.getAmount();
                if (!simulate) {
                    if (!this.isLocked()) {
                        bigStack.setStack(ItemStack.f_41583_);
                    }
                    bigStack.setAmount(0);
                    this.onChange();
                }
                out.m_41764_(newAmount);
                return out;
            }
            if (!simulate) {
                bigStack.setAmount(bigStack.getAmount() - amount);
                this.onChange();
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)bigStack.getStack(), (int)amount);
        }
        return ItemStack.f_41583_;
    }

    public boolean isLocked() {
        return true;
    }

    public int getSlotLimit(int slot) {
        int slotAmount = this.type.getSlotAmount();
        if (this.hasDowngrade()) {
            slotAmount = 64;
        }
        return (int)Math.min(Integer.MAX_VALUE, (long)slotAmount * this.getMultiplier());
    }

    private long getMultiplier() {
        return this.multiplier;
    }

    private boolean hasDowngrade() {
        return this.downgrade;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return !stack.m_41619_();
    }

    public List<BigInventoryHandler.BigStack> getStoredStacks() {
        return this.storedStacks;
    }
}

