/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.network;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.function.Function;
import li.cil.scannable.common.network.message.AbstractMessage;
import li.cil.scannable.common.network.message.RemoveConfiguredModuleItemAtMessage;
import li.cil.scannable.common.network.message.SetConfiguredModuleItemAtMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class Network {
    private static final HashMap<Class<? extends AbstractMessage>, ResourceLocation> PACKET_MAP = new HashMap();
    private static final ResourceLocation SET_CONFIGURED_MODULE_ITEM = new ResourceLocation("scannable", "set_module_item");
    private static final ResourceLocation REMOVE_CONFIGURED_MODULE_ITEM = new ResourceLocation("scannable", "remove_module_item");

    public static void initialize() {
        Network.registerMessageToServer(REMOVE_CONFIGURED_MODULE_ITEM, RemoveConfiguredModuleItemAtMessage.class, RemoveConfiguredModuleItemAtMessage::new);
        Network.registerMessageToServer(SET_CONFIGURED_MODULE_ITEM, SetConfiguredModuleItemAtMessage.class, SetConfiguredModuleItemAtMessage::new);
    }

    private static <T extends AbstractMessage> void registerMessageToServer(ResourceLocation location, Class<T> type, Function<FriendlyByteBuf, T> decoder) {
        PACKET_MAP.put(type, location);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)location, (buffer, context) -> {
            AbstractMessage message = (AbstractMessage)decoder.apply(buffer);
            context.queue(() -> message.handleMessage(context));
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void sendToServer(AbstractMessage message) {
        ResourceLocation loc = PACKET_MAP.get(message.getClass());
        if (loc == null) {
            throw new IllegalArgumentException("Invalid message type");
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        message.toBytes(buf);
        NetworkManager.sendToServer((ResourceLocation)loc, (FriendlyByteBuf)buf);
    }
}

