/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.config;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.HashSet;
import java.util.Set;
import li.cil.scannable.common.config.forge.CommonConfigImpl;
import li.cil.scannable.util.config.Comment;
import li.cil.scannable.util.config.ItemType;
import li.cil.scannable.util.config.Max;
import li.cil.scannable.util.config.Min;
import li.cil.scannable.util.config.Path;
import li.cil.scannable.util.config.WorldRestart;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;

public final class CommonConfig {
    @Path(value="energy")
    @WorldRestart
    @Comment(value={"Whether to consume energy when performing a scan. Will make the scanner a chargeable item."})
    public static boolean useEnergy = true;
    @Path(value="energy")
    @WorldRestart
    @Min(value=0.0)
    @Comment(value={"Amount of energy that can be stored in a scanner."})
    public static int energyCapacityScanner = 5000;
    @Path(value="energy")
    @WorldRestart
    @Min(value=0.0)
    @Comment(value={"Amount of energy used by the range module per scan."})
    public static int energyCostModuleRange = 100;
    @Path(value="energy")
    @WorldRestart
    @Min(value=0.0)
    @Comment(value={"Amount of energy used by the animal module per scan."})
    public static int energyCostModuleAnimal = 25;
    @Path(value="energy")
    @WorldRestart
    @Min(value=0.0)
    @Comment(value={"Amount of energy used by the monster module per scan."})
    public static int energyCostModuleMonster = 50;
    @Path(value="energy")
    @WorldRestart
    @Min(value=0.0)
    @Comment(value={"Amount of energy used by the common ore module per scan."})
    public static int energyCostModuleOreCommon = 75;
    @Path(value="energy")
    @WorldRestart
    @Min(value=0.0)
    @Comment(value={"Amount of energy used by the rare ore module per scan."})
    public static int energyCostModuleOreRare = 100;
    @Path(value="energy")
    @WorldRestart
    @Min(value=0.0)
    @Comment(value={"Amount of energy used by the block module per scan."})
    public static int energyCostModuleBlock = 100;
    @Path(value="energy")
    @WorldRestart
    @Min(value=0.0)
    @Comment(value={"Amount of energy used by the fluid module per scan."})
    public static int energyCostModuleFluid = 50;
    @Path(value="energy")
    @WorldRestart
    @Min(value=0.0)
    @Comment(value={"Amount of energy used by the entity module per scan."})
    public static int energyCostModuleEntity = 75;
    @Path(value="energy")
    @WorldRestart
    @Min(value=0.0)
    @Comment(value={"Amount of energy used by the chest module per scan."})
    public static int energyCostModuleChest = 100;
    @Path(value="range")
    @WorldRestart
    @Min(value=0.0)
    @Max(value=1.0)
    @Comment(value={"Relative amount of base scan radius added by each installed range module."})
    public static float rangeModifierModuleRange = 0.5f;
    @Path(value="range")
    @WorldRestart
    @Min(value=0.0)
    @Max(value=1.0)
    @Comment(value={"Relative effective range of the common ore module."})
    public static float rangeModifierModuleOreCommon = 0.25f;
    @Path(value="range")
    @WorldRestart
    @Min(value=0.0)
    @Max(value=1.0)
    @Comment(value={"Relative effective range of the rare ore module."})
    public static float rangeModifierModuleOreRare = 0.25f;
    @Path(value="range")
    @WorldRestart
    @Min(value=0.0)
    @Max(value=1.0)
    @Comment(value={"Relative effective range of the block module."})
    public static float rangeModifierModuleBlock = 0.5f;
    @Path(value="range")
    @WorldRestart
    @Min(value=0.0)
    @Max(value=1.0)
    @Comment(value={"Relative effective range of the fluid module."})
    public static float rangeModifierModuleFluid = 0.5f;
    @Path(value="range")
    @WorldRestart
    @Min(value=0.0)
    @Max(value=1.0)
    @Comment(value={"Relative effective range of the chest module."})
    public static float rangeModifierModuleChest = 0.25f;
    @Path(value="general")
    @WorldRestart
    @Min(value=16.0)
    @Max(value=128.0)
    @Comment(value={"The basic scan radius without range modules. Higher values mean more computational\noverhead and thus potentially worse performance while scanning."})
    public static int baseScanRadius = 64;
    @Path(value="general")
    @WorldRestart
    @Min(value=1000.0)
    @Max(value=300000.0)
    @Comment(value={"How long the results from a scan should remain visible, in milliseconds."})
    public static int scanStayDuration = 10000;
    @Path(value="blocks")
    @WorldRestart
    @Comment(value={"Registry names of blocks that should be ignored.\nBlocks in this list will be excluded from the default ore list based on the forge:ores\ntag and it will be impossible to tune the entity module to this block."})
    @ItemType(value=ResourceLocation.class)
    public static Set<ResourceLocation> ignoredBlocks = (Set)Util.m_137469_(new HashSet(), c -> c.add(BuiltInRegistries.f_256975_.m_7981_((Object)Blocks.f_50272_)));
    @Path(value="blocks")
    @WorldRestart
    @Comment(value={"Tag names of block tags that should be ignored.\nBlocks matching a tag in this list will be excluded from the default ore list based on the\nforge:ores tag and it will be impossible to tune the entity module to this block."})
    @ItemType(value=ResourceLocation.class)
    public static Set<ResourceLocation> ignoredBlockTags = new HashSet<ResourceLocation>();
    @Path(value="ores")
    @WorldRestart
    @Comment(value={"Registry names of blocks considered 'common ores', requiring the common ore scanner module."})
    @ItemType(value=ResourceLocation.class)
    public static Set<ResourceLocation> commonOreBlocks = (Set)Util.m_137469_(new HashSet(), c -> c.add(BuiltInRegistries.f_256975_.m_7981_((Object)Blocks.f_50129_)));
    @Path(value="ores")
    @WorldRestart
    @Comment(value={"Block tags of blocks considered 'common ores', requiring the common ore scanner module."})
    @ItemType(value=ResourceLocation.class)
    public static Set<ResourceLocation> commonOreBlockTags = CommonConfig.getDefaultCommonOreTags();
    @Path(value="ores")
    @WorldRestart
    @Comment(value={"Registry names of blocks considered 'rare ores', requiring the rare ore scanner module."})
    @ItemType(value=ResourceLocation.class)
    public static Set<ResourceLocation> rareOreBlocks = (Set)Util.m_137469_(new HashSet(), c -> c.add(BuiltInRegistries.f_256975_.m_7981_((Object)Blocks.f_50141_)));
    @Path(value="ores")
    @WorldRestart
    @Comment(value={"Block tags of blocks considered 'rare ores', requiring the common ore scanner module.\nAny block with the forge:ores tag is implicitly in this list, unless the block also\nmatches an ignored or common ore block tag, or is an ignored or common block."})
    @ItemType(value=ResourceLocation.class)
    public static Set<ResourceLocation> rareOreBlockTags = new HashSet<ResourceLocation>();
    @Path(value="fluids")
    @WorldRestart
    @Comment(value={"Fluid tags of fluids that should be ignored."})
    @ItemType(value=ResourceLocation.class)
    public static Set<ResourceLocation> ignoredFluidTags = new HashSet<ResourceLocation>();
    @Path(value="chests")
    @WorldRestart
    @Comment(value={"Registry names of blocks considered 'chests', requiring the chest scanner module."})
    @ItemType(value=ResourceLocation.class)
    public static Set<ResourceLocation> commonChestBlocks = new HashSet<ResourceLocation>();
    @Path(value="chests")
    @WorldRestart
    @Comment(value={"Registry names of blocks considered 'chests', requiring the chest scanner module."})
    @ItemType(value=ResourceLocation.class)
    public static Set<ResourceLocation> commonChestTags = CommonConfig.getDefaultChestsTags();

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static Set<ResourceLocation> getDefaultCommonOreTags() {
        return CommonConfigImpl.getDefaultCommonOreTags();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static Set<ResourceLocation> getDefaultChestsTags() {
        return CommonConfigImpl.getDefaultChestsTags();
    }
}

