/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.client.scanning;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import li.cil.scannable.api.API;
import li.cil.scannable.api.prefab.AbstractScanResultProvider;
import li.cil.scannable.api.scanning.EntityScannerModule;
import li.cil.scannable.api.scanning.ScanResult;
import li.cil.scannable.api.scanning.ScanResultRenderContext;
import li.cil.scannable.api.scanning.ScannerModule;
import li.cil.scannable.common.item.ScannerModuleItem;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class ScanResultProviderEntity
extends AbstractScanResultProvider {
    private final List<Predicate<Entity>> filters = new ArrayList<Predicate<Entity>>();
    private final Map<Predicate<Entity>, EntityScannerModule> filterToModule = new HashMap<Predicate<Entity>, EntityScannerModule>();
    private final ArrayList<Entity> entities = new ArrayList();
    private int currentEntityIndex;
    private int entitiesStep;
    private final List<ScanResultEntity> results = new ArrayList<ScanResultEntity>();

    @Override
    public void initialize(Player player, Collection<ItemStack> modules, Vec3 center, float radius, int scanTicks) {
        super.initialize(player, modules, center, radius, scanTicks);
        this.filters.clear();
        this.filterToModule.clear();
        for (ItemStack stack : modules) {
            Optional<ScannerModule> capability = ScannerModuleItem.getModule(stack);
            capability.ifPresent(module -> {
                if (module instanceof EntityScannerModule) {
                    EntityScannerModule entityModule = (EntityScannerModule)module;
                    Predicate<Entity> filter = entityModule.getFilter(stack);
                    this.filters.add(filter);
                    this.filterToModule.put(filter, entityModule);
                }
            });
        }
        this.entities.clear();
        for (Entity entity : player.m_9236_().m_142646_().m_142273_()) {
            this.entities.add(entity);
        }
        this.currentEntityIndex = 0;
        this.entitiesStep = Mth.m_14167_((float)((float)this.entities.size() / (float)scanTicks));
    }

    @Override
    public void computeScanResults() {
        int end = Math.min(this.currentEntityIndex + this.entitiesStep, this.entities.size());
        while (this.currentEntityIndex < end) {
            Vec3 position;
            Entity entity = this.entities.get(this.currentEntityIndex);
            if (entity.m_6084_() && this.center.m_82557_(position = entity.m_20182_()) < (double)(this.radius * this.radius)) {
                ResourceLocation icon = API.ICON_INFO;
                boolean hasMatch = false;
                for (Predicate<Entity> filter : this.filters) {
                    if (!filter.test(entity)) continue;
                    hasMatch = true;
                    Optional<ResourceLocation> filterIcon = this.filterToModule.get(filter).getIcon(entity);
                    if (!filterIcon.isPresent()) continue;
                    icon = filterIcon.get();
                    break;
                }
                if (hasMatch) {
                    this.results.add(new ScanResultEntity(entity, icon));
                }
            }
            ++this.currentEntityIndex;
        }
    }

    @Override
    public void collectScanResults(BlockGetter level, Consumer<ScanResult> callback) {
        this.results.forEach(callback);
    }

    @Override
    public void render(ScanResultRenderContext context, MultiBufferSource bufferSource, PoseStack poseStack, Camera renderInfo, float partialTicks, List<ScanResult> results) {
        if (context != ScanResultRenderContext.GUI) {
            return;
        }
        float yaw = renderInfo.m_90590_();
        float pitch = renderInfo.m_90589_();
        Vec3 lookVec = new Vec3(renderInfo.m_253058_());
        Vec3 viewerEyes = renderInfo.m_90583_();
        boolean showDistance = renderInfo.m_90592_().m_6144_();
        results.sort(Comparator.comparing(result -> {
            ScanResultEntity resultEntity = (ScanResultEntity)result;
            Vec3 entityEyes = resultEntity.entity.m_20299_(partialTicks);
            Vec3 toResult = entityEyes.m_82546_(viewerEyes);
            return lookVec.m_82526_(toResult.m_82541_());
        }));
        for (ScanResult result2 : results) {
            ScanResultEntity resultEntity = (ScanResultEntity)result2;
            Component name = resultEntity.entity.m_7755_();
            ResourceLocation icon = resultEntity.getIcon();
            Vec3 resultPos = resultEntity.entity.m_20299_(partialTicks);
            float distance = showDistance ? (float)resultPos.m_82546_(viewerEyes).m_82553_() : 0.0f;
            ScanResultProviderEntity.renderIconLabel(bufferSource, poseStack, yaw, pitch, lookVec, viewerEyes, distance, resultPos, icon, name);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.filters.clear();
        this.filterToModule.clear();
        this.currentEntityIndex = 0;
        this.entitiesStep = 0;
        this.entities.clear();
        this.results.clear();
    }

    private record ScanResultEntity(Entity entity, ResourceLocation icon) implements ScanResult
    {
        public ResourceLocation getIcon() {
            return this.icon;
        }

        @Override
        public Vec3 getPosition() {
            return this.entity.m_20182_();
        }

        @Override
        public AABB getRenderBounds() {
            return this.entity.m_6921_();
        }
    }
}

