/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import li.cil.scannable.client.gui.AbstractConfigurableScannerModuleContainerScreen;
import li.cil.scannable.common.config.Strings;
import li.cil.scannable.common.container.EntityModuleContainerMenu;
import li.cil.scannable.common.item.ConfigurableEntityScannerModuleItem;
import li.cil.scannable.common.network.Network;
import li.cil.scannable.common.network.message.SetConfiguredModuleItemAtMessage;
import li.cil.scannable.util.UnitConversion;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class ConfigurableEntityScannerModuleContainerScreen
extends AbstractConfigurableScannerModuleContainerScreen<EntityModuleContainerMenu, EntityType<?>> {
    private static final Map<EntityType<?>, Entity> RENDER_ENTITIES = new HashMap();

    public ConfigurableEntityScannerModuleContainerScreen(EntityModuleContainerMenu container, Inventory inventory, Component title) {
        super(container, inventory, title, Strings.GUI_ENTITIES_LIST_CAPTION);
    }

    @Override
    protected List<EntityType<?>> getConfiguredItems(ItemStack stack) {
        return ConfigurableEntityScannerModuleItem.getEntityTypes(stack);
    }

    @Override
    protected Component getItemName(EntityType<?> entityType) {
        return entityType.m_20676_();
    }

    @Override
    protected void renderConfiguredItem(GuiGraphics graphics, EntityType<?> entityType, int x, int y) {
        this.renderEntity(graphics, x + 8, y + 13, entityType);
    }

    @Override
    protected void configureItemAt(ItemStack stack, int slot, ItemStack value) {
        if (value.m_41720_() instanceof SpawnEggItem) {
            EntityType entityType = ((SpawnEggItem)value.m_41720_()).m_43228_(value.m_41783_());
            BuiltInRegistries.f_256780_.m_7854_((Object)entityType).ifPresent(entityTypeResourceKey -> Network.sendToServer(new SetConfiguredModuleItemAtMessage(((EntityModuleContainerMenu)this.f_97732_).f_38840_, slot, entityTypeResourceKey.m_135782_())));
        }
    }

    private void renderEntity(GuiGraphics graphics, int x, int y, EntityType<?> entityType) {
        Entity entity = this.getRenderEntity(entityType);
        if (entity == null) {
            return;
        }
        entity.m_284535_(((EntityModuleContainerMenu)this.f_97732_).getPlayer().m_9236_());
        EntityDimensions bounds = entityType.m_20680_();
        float size = Math.max(bounds.f_20377_, bounds.f_20378_);
        float scale = 11.0f / size;
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)x, (float)y, 100.0f);
        poseStack.m_85841_(scale, scale, scale);
        Quaternionf quaternion = new Quaternionf().rotationZ(UnitConversion.toRadians(180.0f));
        quaternion.mul((Quaternionfc)new Quaternionf().rotationX(UnitConversion.toRadians(20.0f)));
        quaternion.mul((Quaternionfc)new Quaternionf().rotationY(UnitConversion.toRadians(30.0f)));
        poseStack.m_252781_(quaternion);
        EntityRenderDispatcher renderManager = Minecraft.m_91087_().m_91290_();
        quaternion.conjugate();
        renderManager.m_252923_(quaternion);
        renderManager.m_114468_(false);
        renderManager.m_114384_(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, (MultiBufferSource)graphics.m_280091_(), 0xF000F0);
        renderManager.m_114468_(true);
        poseStack.m_85849_();
    }

    @Nullable
    private Entity getRenderEntity(EntityType<?> entityType) {
        return RENDER_ENTITIES.computeIfAbsent(entityType, t -> t.m_20615_(((EntityModuleContainerMenu)this.f_97732_).getPlayer().m_9236_()));
    }
}

